<?php
/*
Template Name Posts: Trip Section
*/

global $author;

?>

<?php get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">

	<?php while ( have_posts() ) : the_post(); ?>

		<nav>
			<div id="page-menu"></div>
			<div id="author-mini">
				<?php if(get_field('profile_name', $author) && get_field('profile_image', $author)): ?>
					<span class="author-name"><!--<?php the_field('profile_name',$author) ?>--></span>
					<a href="#about" rel="scroll"><img class="author-photo" src="<?php the_field('profile_image', $author); ?>" alt="<?php the_field('profile_name',$author); ?> Profile Photo" /></a>
				<?php endif; ?>
			</div>
		</nav>

		<div id="to-top"><a href="#primary" rel="scroll"><i class="icon-arrow-up"></i></a></div>

		<header class="full" data-top="background-position: 50% 0px;" data-top-bottom="background-position: 50% 200px;" style="background-image: url(<?php the_field('overview_image'); ?>);">
			<div class="title-container">
				<div class="title-contents">
					<h1><?php the_title(); ?></h1>
					<div class="subhead">
						<div class="divide-section left"><div class="full-divide"></div></div>
						<?php if( get_field('logo') ) : ?>
						<img class="section-logo" src="<?php the_field('logo'); ?>" />
						<?php else : ?>
						<span class="divide-icon"><i class="icon-star-empty"></i></span>
						<?php endif; ?>
						<div class="divide-section right"><div class="full-divide"></div></div>
					</div>
				</div>
			</div>
		</header>

		<div id="summary">

			<main>
				<?php
					$summary = add_anchor_scroll(get_the_content());
					echo $summary;
				?>
			</main>

			<footer>
				<div class="full-divide"></div>
				<span class="divide-icon"><i class="icon-star-empty"></i></span>
				<?php
					if( get_field('previous') ) :
						$prev = get_field('previous');
						?>
						<div class="prev">
							<!--<a href="<?php echo get_permalink( $prev->ID ); ?>">
								<?php echo apply_filters( 'the_title', $prev->post_title ); ?>
								<i class="icon-arrow-left"></i>
							</a>-->
						</div>
				<?php endif; ?>
				<?php
					if( get_field('next') && get_field('status') == 'after' || get_field('status') == 'draft' ) :
						$next = get_field('next');
						?>
						<div class="next">
							<!--<a href="<?php echo get_permalink( $next->ID ); ?>">
								<?php echo apply_filters( 'the_title', $next->post_title ); ?>
								<i class="icon-arrow-right"></i>
							</a>-->
						</div>
				<?php endif; ?>
			</footer>
		</div>

		<div id="content">

		<?php $posts = get_posts(array('post_type' => array('post','gallery','picto'), 'posts_per_page' => -1, 'meta_query' => array(array('key' => 'area','value' => '"' . get_the_ID() . '"','compare' => 'LIKE')), 'order' => 'ASC', 'orderby' => 'date')); ?>

		<?php if( $posts ): ?>
			<?php foreach( $posts as $post ): ?>
				
				<?php setup_postdata( $post ); ?>
				<?php get_template_part( get_content_template($post) ); ?>
				
			<?php endforeach; ?>
		<?php endif; ?>
 
		</div>

	<?php endwhile; // end of the loop. ?>

	</main>
</div>

<?php get_footer(); ?>