<?php
/*
Template Name Posts: Trip Overview
*/

global $author;

$segments = new WP_Query( array( 'post_parent' => $post->ID, 'post_type' => 'trip', 'order' => 'ASC') );
$stack = 8;

?>

<?php get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">

	<nav>
		<div id="to-top"><a href="#primary" rel="scroll"><i class="icon-arrow-up"></i></a></div>
	</nav>

		<?php $segment = set_current_trip_segment(); 
			//echo $segment['end'];
		?>

	<?php while ( have_posts() ) : the_post(); ?>

	<section class="overview" id="skrollr-body">

		<header id="head<?php the_ID(); ?>" class="segment" style="z-index: <?php echo $stack; ?>;">
			<div class="bcg" data-top="background-position: 50% 0px;" data-top-bottom="background-position: 50% 100px;" data-anchor-target="#head<?php the_ID(); ?>" style="background-image: url(<?php the_field('overview_header'); ?>);"></div>

			<h2 data-top="opacity: 1; position: absolute; bottom: 50%;" data-200-top-bottom="opacity: 0.6; position: absolute; bottom: 8%;" data-top-bottom="opacity: 0; position: absolute; bottom: 8%;" data-anchor-target="#head<?php the_ID(); ?>"><?php the_title(); ?></h2>

			<?php if( get_field('profile_image', $author) ): ?>
			<div class="author-container" data-top="opacity: 1; position: absolute; bottom: 35%; transform: scale(1);" data-255-top-bottom="opacity: 0.3; bottom: 2%; transform: scale(0.3);" data-250-top-bottom="opacity: 0;" data-anchor-target="#head<?php the_ID(); ?>">
				<a href="#foot<?php the_ID(); ?>" rel="scroll"><img class="author-photo top" src="<?php the_field('profile_image', $author); ?>" alt="<?php the_field('profile_name',$author); ?> Profile Photo" /></a>
			</div>
			<?php endif; ?>
			
			<?php if( get_field('transport_out') ) : ?>
			<div class="transport-container" data-top="opacity: 1; position: absolute; bottom: 5%;" data-250-top-bottom="opacity: 1; position: absolute; bottom: 5%;" data-80-top-bottom="opacity: 1; position: absolute; bottom: -40%;" data-40-top-bottom="opacity: 0;" data-anchor-target="#head<?php the_ID(); ?>">
				<img src="<?php echo get_template_directory_uri() . '/images/' . get_field('transport_out') . '.png'; ?>" />
			</div>
			<?php endif; ?>
		</header>

		<?php while ($segments->have_posts()) : $segments->the_post(); ?>
		<?php $stack--; ?>
		<article id="seg<?php the_ID(); ?>" class="segment" style="z-index: <?php echo $stack; ?>;">
			<!--<a href="<?php the_permalink(); ?>" ></a>-->

			<div class="bcg" data-bottom-top="background-position: 50% -100px; background-size: cover;" data-top-bottom="background-position: 50% 100px; background-size: cover;" data-anchor-target="#seg<?php the_ID(); ?>" style="background-image: url(<?php the_field('overview_image'); ?>);"></div>
			
			<!--<h2 data-40-top="opacity: 0; position: absolute; top: 18%" data-top="opacity: 1; position: absolute; top: 18%;" data-250-top-bottom="opacity 1; top: 70%;" data-210-top-bottom="opacity: 0; position: absolute; top: 70%" data-anchor-target="#seg<?php the_ID(); ?>"><?php the_title(); ?></h2>-->
			<section class="trip-info" data--40-center-top="opacity: 0; position: absolute; top: 45%" data--80-center-top="opacity: 1;" data-250-top-bottom="opacity 1;" data-210-top-bottom="opacity: 0; position: absolute; top: 45%" data-anchor-target="#seg<?php the_ID(); ?>">
				<h2 ><?php the_title(); ?></h2>
				<a href="<?php the_permalink(); ?>">View Journal</a>
			</section>

			<?php if( get_field('transport_out') ) : ?>
			<div class="transport-container" data--40-top="opacity: 0; position: absolute; bottom: 22%;" data--80-top="opacity: 1; position: absolute; bottom: 22%;" data-80-top-bottom="opacity: 1; position: absolute; bottom: -40%;" data-40-top-bottom="opacity: 0;" data-anchor-target="#seg<?php the_ID(); ?>">
				<img src="<?php echo get_template_directory_uri() . '/images/' . get_field('transport_out') . '.png'; ?>" />
			</div>
			<?php endif; ?>
		</article>
		<?php endwhile; ?>
		<?php wp_reset_postdata(); ?>

		<?php $stack--; ?>
		<footer id="foot<?php the_ID(); ?>" class="segment" style="z-index: <?php echo $stack; ?>;">
			<!--<div class="bcg" data-bottom-top="background-position: 50% 0px;" data-bottom="background-position: 50% -100px;" data-anchor-target="#foot<?php the_ID(); ?>" style="background-image: url(<?php the_field('overview_header'); ?>);"></div>-->
			<?php if( get_field('profile_image', $author) ): ?>
			<div class="author-container" data-40-top="opacity: 0; position: absolute; top: 15%; transform: scale(0.25);" data-top="opacity: 1; position: absolute; top: 10%; transform: scale(1);" data-anchor-target="#foot<?php the_ID(); ?>">
				<span class="about-picto" data-20-top="opacity: 0; top: -15px; margin-left: 15px;" data-top="opacity: 1; top: -60px; margin-left: 60px;" data-anchor-target="#foot<?php the_ID(); ?>"><i class="icon-hi"></i></span>
				<a href="#about" rel="scroll"><img class="author-photo bottom" src="<?php the_field('profile_image', $author); ?>" alt="<?php the_field('profile_name',$author); ?> Profile Photo" /></a>
				<?php echo get_page($author)->post_content; ?>
				<span class="copyright">Copyright &copy; 2014 Andrew Cobley</span>
			</div>
			<?php endif; ?>
		</footer>
	
	</section>

	<?php endwhile; ?>

	</main>
</div>

<?php get_footer(); ?>


