<?php
/*
Template Name Posts: Trip Overview
*/

global $author;

?>

<?php get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">

	<nav>
		<div id="to-top"><a href="#primary" rel="scroll"><i class="icon-arrow-up"></i></a></div>
	</nav>

		<?php $segment = set_current_trip_segment(); 
			//echo $segment['end'];
		?>

	<?php while ( have_posts() ) : the_post(); ?>

		<header class="overview">
			<h1><?php the_title() ?></h1>
		</header>
		
		<div id="status">
			<header>
				<div class="full-divide"></div>
				<span class="divide-icon"><i class="icon-star-empty"></i></span>
			</header>
			<main>
				<p>
				<?php echo $segment['greeting']; ?>, my name is <a href="#about" class="author" rel="scroll">Andrew</a> and 
				<?php echo $segment['intro']; ?>
				</p>
				<?php if( $segment['time'] ) : ?>
				<p><?php echo $segment['time']; ?></p>
				<?php endif; ?>
				<?php if( $segment['entries'] || $segment['outro'] ) : ?>
				<p><?php echo $segment['entries']; ?><?php echo $segment['outro']; ?></p>
				<?php endif; ?>
			</main>
			<footer>
				<div class="full-divide"></div>
				<span class="divide-icon"><i class="icon-globe"></i></span>
			</footer>
		</div>

	<?php endwhile; ?>

	<div id="about-divide">
		<span class="about-picto"><i class="icon-hi"></i></span>
	</div>

	</main>
</div>

<?php get_footer(); ?>
