<?php
/*
Template Name Posts: Trip Overview
*/

global $author;

$segments = new WP_Query( array( 'post_parent' => $post->ID, 'post_type' => 'trip', 'order' => 'ASC') );

?>

<?php get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">

	<nav>
		<div id="to-top"><a href="#primary" rel="scroll"><i class="icon-arrow-up"></i></a></div>
	</nav>

		<?php $segment = set_current_trip_segment(); 
			//echo $segment['end'];
		?>

	<?php while ( have_posts() ) : the_post(); ?>

	<section class="overview">

		<header id="head<?php the_ID(); ?>" class="segment">
			<h2 data-top="opacity: 1; top: 22%;" data-120-center-bottom="opacity: 1; top: 22%;" data-40-center-bottom="opacity: 0; position: fixed; top: 2%;" data-anchor-target="#head<?php the_ID(); ?>"><?php the_title(); ?></h2>

			<?php if( get_field('profile_image', $author) ): ?>
			<div class="author-container" data-top="opacity: 1; position: fixed; top: 45%; transform: scale(1);" data--50-top="opacity: 0; top: 70%; transform: scale(0.2);" data-anchor-target="#head<?php the_ID(); ?>">
				<a href="#about" rel="scroll"><img class="author-photo" src="<?php the_field('profile_image', $author); ?>" alt="<?php the_field('profile_name',$author); ?> Profile Photo" /></a>
			</div>
			<?php endif; ?>
			
			<?php if( get_field('transport_out') ) : ?>
			<div class="transport-container" data-top="opacity: 1; top: 78%;" data--80-center-bottom="opacity: 1; top: 38%;" data--100-center-bottom="opacity: 0; position: fixed; top: 38%;" data-anchor-target="#head<?php the_ID(); ?>">
				<img src="<?php echo get_template_directory_uri() . '/images/' . get_field('transport_out') . '.png'; ?>" />
			</div>
			<?php endif; ?>
		</header>

		<?php while ($segments->have_posts()) : $segments->the_post(); ?>
		<article id="seg<?php the_ID(); ?>" class="segment">
			<div class="bcg" style="background-image: url(<?php the_field('header_image'); ?>);" data-anchor-target="#seg<?php the_ID(); ?>"></div>
			<h2 data--40-center-top="opacity: 0; position: fixed; top: 72%;" data--120-center-top="opacity: 1; top: 42%;" data-120-center-bottom="opacity: 1; top: 42%;" data-40-center-bottom="opacity: 0; position: fixed; top: 12%;" data-anchor-target="#seg<?php the_ID(); ?>"><?php the_title(); ?></h2>
			<?php if( get_field('transport_out') ) : ?>
			<div class="transport-container" data-180-center-bottom="opacity: 0; position: fixed; top: 58%;" data-120-center-bottom="opacity: 1; top: 58%;" data--80-center-bottom="opacity: 1; top: 38%;" data--100-center-bottom="opacity: 0; position: fixed; top: 38%;" data-anchor-target="#seg<?php the_ID(); ?>">
				<img src="<?php echo get_template_directory_uri() . '/images/' . get_field('transport_out') . '.png'; ?>" />
			</div>
			<?php endif; ?>
		</article>
		<?php endwhile; ?>
		<?php wp_reset_postdata(); ?>

		<footer>
			<div class="inner">
				<h1><?php the_title(); ?></h1>
			</div>
		</footer>
	
	</section>

	<?php endwhile; ?>

	</main>
</div>

<?php get_footer(); ?>


