$(function()
{
	// Rezise div containers to viewport height and add listener for window change..
	resizeContainersToViewport();
	resizeSectionHeader();
	$(window).resize(function() {
		resizeContainersToViewport();
		resizeSectionHeader();
	});
	// Initialise scroller library
	var s = skrollr.init({
		forceHeight: false,
        render: function(data) {
            //Debugging - Log the current scroll position.
            //console.log(data.curTop);
        }
    });

    s.refresh($('.segment'));

	// Initialise any gallery slider on page.
	$('.gallery-wrap').each(function()
	{
		var gallery_id = $(this).attr('id');
		$('#' + gallery_id).responsiveSlides(
		{
			auto: true,
			speed: 1000,
			timeout: 10000,
			nav: true,
			prevText: '',
			nextText: '',
			pager: true,
			controlContainer: 'div.rslides-controls',
			pause: true,
			pauseControls: true
		});
	});

	$(document).on('mouseover','div#summary a',function()
	{
		console.log('over');
		$(this).parent('span').addClass('line-hover');
	});

	$(document).on('mouseout','div#summary a',function()
	{
		console.log('out');
		$(this).parent('span').removeClass('line-hover');
	});


});

function resizeContainersToViewport() {
	$('.overview header').css('height', window.innerHeight);
	$('.overview article').css('height', window.innerHeight);
	$('.overview footer').css('height', window.innerHeight);

	if( window.innerHeight > parseInt($('.overview footer').css('max-height')) ) {
		$('.overview footer').css('margin-bottom', ( window.innerHeight - parseInt($('.overview footer').css('max-height')) ) );
	}
	
}

function resizeSectionHeader() {
	$('header.full').css('height', window.innerHeight);	
}