<?php
/**
 * @package ac-travel
 */
?>

<article id="<?php the_ID(); ?>" class="gallery">

	<?php if( get_field('display_title') ) : ?>
	<header>
		<h1><?php the_title(); ?></h1>
	</header>
	<?php endif; ?>

	<main>
		<?php $photos = get_field('photos'); ?>
		<?php if( $photos ): ?>
			<ul id="gallery-<?php the_ID(); ?>" class="gallery-wrap rslides">
				<?php foreach( $photos as $photo): ?>
					<li class="<?php echo get_field('gallery_layout', $photo['id']); ?>">
						<img src="<?php echo $photo['url']; ?>" alt="<?php echo $photo['alt']; ?>" /> 
						<aside>
							<span class="description"><?php echo $photo['description']; ?></span>
						</aside>
					</li>
				<?php endforeach; ?>
			</ul>
			<div class="rslides-controls-wrap">
				<div class="rslides-controls"></div>
			</div>
		<?php endif; ?>
	</main>

</article><!-- #post-## -->
