<?php
/*
Plugin Name: AC-TRAVEL
Description: Site specific code changes for AC-TRAVEL
*/

global $post_color;
$post_color = '';

/**
 * Setup Current Trip Segment For Overview
 * @return $segment array
 */

function set_current_trip_segment()
{
	$data = array();

	$segment = get_current_trip_segment();

	$data['start'] = $segment['start'];
	$data['end'] = $segment['end'];

	// Set Greeting
	$data['greeting'] = $segment['greeting'];

	// Set Intro
	$intro = str_ireplace('<p>','',$segment['intro']);
	$data['intro'] = str_ireplace('</p>','',$intro); 

	// Set Time
	if( $segment['display_time'] && $segment['timezone'] )
	{
		date_default_timezone_set($segment['timezone']);
		$time = date('H:i');
		if( strtotime($time) >= strtotime('00:00:00') && strtotime($time) < strtotime('08:00:00') || strtotime($time) >= strtotime('23:00:00') && strtotime($time) <= strtotime('23:59:59') )
		{
			$data['time'] = 'It is currently <span class="time">'.$time.'</span> here so I am probably still asleep!';
		}
		else
		{
			$data['time'] = 'It is currently <span class="time">'.$time.'</span> here '.$segment['time_text'];
		}
	}
	else
	{
		$data['time'] = '';
	}

	// Set Post
	if( $segment['section'] ) 
	{
		$section = $segment['section'];
		if( get_children( array('post_parent' => $section->ID) ) )
		{
			$entries = str_ireplace('<p>','',$segment['post_text']);
			$data['entries'] = str_ireplace('</p>','',$entries);
			$data['entries'] = $data['entries'].' ';
		}
		else
		{
			$entries = str_ireplace('<p>','',$segment['no_post_text']);
			$data['entries'] = str_ireplace('</p>','',$entries); 
			$data['entries'] = $data['entries'].' ';
		}
	}
	else
	{
		$data['entries'] = "";
	}

	// Set Outro
	$outro = str_ireplace('<p>','',$segment['outro']);
	$data['outro'] = str_ireplace('</p>','',$outro); 

	return $data;

}

function get_current_trip_segment() {
	$current = time();
	//$current = 1399194000;
	//$current = 1399255200;
	//$current = 1399701600;
	//$current = 1399766400;
	//$current = 1400184000;
	
	if( get_field('trip_segment') ) :	
		$segments = get_field('trip_segment');
		foreach($segments as $segment) :
			if( $current >= $segment['start'] && $current < $segment['end'] ) :
				return $segment;
			endif;	
		endforeach;
	endif;
}

/**
 * Setup Picto for given icon data.
 *
 * @param $icon
 * @return $picto array
 */

function get_picto($icon) {
	$picto = array();

	// Get Picto Name
	if( $icon['icon'] )
	{
		$picto['name'] = $icon['icon'];
	}
	else if( $icon['custom'] )
	{
		$picto['name'] = $icon['custom'];
	}
	else
	{
		$picto['name'] = 'icon-not-found';
	}

	// Get Picto Scale
	if( $icon['max_scale'] )
	{
		$picto['scale'] = $icon['max_scale'];
	}
	else
	{
		$picto['scale'] = 14;
	}

	// Get Picto Colour
	if( $icon['colour'] == 'inherit')
	{
		global $post_color;
		$picto['colour'] = $post_color;
	}
	else if ( $icon['colour'] == 'custom')
	{
		$picto['colour'] = $icon['custom_colour'];
	}
	else
	{
		$picto['colour'] = '';
	}

	return $picto;
}


/**
 * Add dynamic CSS.
 *
 * @param $content
 * @return $content
 */

function add_custom_stylesheet() {
	wp_register_style('custom', get_template_directory_uri() . '/custom.css');
}
add_action( 'wp_enqueue_scripts', 'add_custom_stylesheet' );


function add_custom_css() {
    wp_enqueue_style('custom');
    if ( get_post_type() == 'trip' ) {
        $color = get_field('colour');
        $custom_css = "article main p a, article main p a:visited, div#summary main a, .line-hover, div#summary header span, div#summary footer, div#summary footer div a:hover { color: {$color} !important; }";
        wp_add_inline_style( 'custom', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'add_custom_css' );


/**
 * Add rel to summary links for scroll.
 *
 * @param $content
 * @return $content
 */

function add_anchor_scroll($content)
{
	return preg_replace_callback('/<a[^>]+/', 'add_anchor_scroll_callback', $content);
}

function add_anchor_scroll_callback($matches)
{
	$link = $matches[0];
	
	if (strpos($link, 'rel') === false)
	{
		$link = $link.'rel="scroll"';
	}

	return $link;
}


// ATTACHMENT FUNCTIONS REPLACED IN ACF!

/**
 * Add location fields to Media Uploader
 *
 * @param $form_fields array, fields to include in attachment form
 * @param $post object, attachment record in database
 * @return $form_fields, modified form fields
 */
 /*
function attachment_media_location( $form_fields, $post ) {
    $form_fields['location_address'] = array(
        'label' => 'Location Address',
        'input' => 'text',
        'value' => get_post_meta( $post->ID, 'location_address', true )
    );
 
    $form_fields['location_geolat'] = array(
        'label' => 'Location GeoLat',
        'input' => 'text',
        'value' => get_post_meta( $post->ID, 'location_geolat', true )
	);

	$form_fields['location_geolng'] = array(
		'label' => 'Location GeoLng',
		'input' => 'text',
		'value' => get_post_meta( $post->ID, 'location_geolng', true )
	);
 
    return $form_fields;
}
 
add_filter( 'attachment_fields_to_edit', 'attachment_media_location', 10, 2 );
*/
/**
 * Save values of location fields in Media Uploader
 *
 * @param $post array, the post data for database
 * @param $attachment array, attachment fields from $_POST form
 * @return $post array, modified post data
 */
 /*
function attachment_media_location_save( $post, $attachment ) {
    if( isset( $attachment['location_name'] ) )
        update_post_meta( $post['ID'], 'location_name', $attachment['location_name'] );
 
    if( isset( $attachment['location_geolat'] ) )
		update_post_meta( $post['ID'], 'location_geolat', $attachment['location_geolat'] );

    if( isset( $attachment['location_geolng'] ) )
		update_post_meta( $post['ID'], 'location_geolng', $attachment['location_geolng'] );
 
    return $post;
}
 
add_filter( 'attachment_fields_to_save', 'attachment_media_location_save', 10, 2 );
*/

/**
 * Set Author ID
 */

function set_author()
{
	global $author;
	$author = get_page_by_title('About')->ID;
}
add_action('wp_head', 'set_author');


/**
 * Set OG Data
 */

function set_og_data()
{
	if(get_post_type() == 'trip')
	{
		echo '<meta property="og:image" content="'.get_field('thumbnail_image').'"/>';
		echo '<link rel="image_src" type="image/jpeg" href="'.get_field('thumbnail_image').'" />';
		echo '<meta property="og:title" content="'.get_the_title().'"/>';
		echo '<meta property="og:site_name" content="'.get_field('profile_name', get_page_by_title('About')->ID).'"/>';
	}
}
add_action('wp_head', 'set_og_data');

/**
 * Get Content Template For Post Type
 */

function get_content_template($post)
{
	$type = get_post_type( $post );
	if($type)
	{
		if($type == 'gallery')
		{
			return 'content-gallery';
		}
		else if ($type == 'picto')
		{
			return 'content-picto';
		}
		else if ($type == 'postcard')
		{
			return 'content-postcard';
		}
		else if($type == 'feature')
		{
			return 'content-future';
		}
	}
	return 'content-post';
}
 

?>