<?php
/*
 	Template Name: Single Project
*/

// Set Project Path

if(get_field('project_root') == 'wp-content')
{
	$p_path = ABSPATH.'wp-content'.get_field('project_path');
	$p_url = content_url().get_field('project_path');
}
else
{
	$p_path = get_field('project_path');
	$p_url = get_field('project_path');
}

$p_path = ABSPATH.'wp-content'.get_field('project_path');
$p_url = content_url().get_field('project_path');

// Include Project Header (include so $p_path can be used)
include(locate_template('header-project.php'));

?>

<body>

	<div id="container">


		<?php
		// Get Project Navigation
		get_template_part('nav-project');

		// Get Project Feature

		?>

		<section class="feature">

			<header class="feature">
				<img src="<?php echo $p_url.get_field('project_logo'); ?>" class="logo" alt="logo" />
			</header>

			<?php if(get_field('feature_template')): ? >
			<section class="feature-main">
				<?php $feature_path = $p_path.'feature/'.get_field('feature_content'); ?>
				<?php include($feature_path); ?>
			</section>
			<?php endif; ?>

		</section>

		<section class="main">
			<?php while ( have_posts() ) : the_post(); ?>
				<?php include('content-single-project.php') ?>
			<?php endwhile; // end of the loop. ?>
		</section> <!-- section.main -->

		<?php
		// Get Project Footer
		include(locate_template('footer-project.php'));

		?>

	</div>

</body>

</html>

