<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <main id="main">
 *
 * @package dev
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>

	<head>

		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="initial-scale=1.0,width=device-width" />
		<title><?php wp_title( '|', true, 'right' ); ?></title>
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<link href="<?php content_url().'/normalize.css' ?>" rel='stylesheet' type='text/css'>
		<link href='http://fonts.googleapis.com/css?family=Open+Sans:400,600' rel='stylesheet' type='text/css'>

		<?php wp_head(); ?>

		<?php if( get_field('css_paths') ): ?>

			<?php while( has_sub_field('css_paths') ): ?>

				<?php $css_path = get_sub_field('css_path'); ?>
				<link rel="stylesheet" href="<?php echo $path; ?>" type="text/css" />

			<?php endwhile; ?>

		<?php endif; ?>

		<?php if( get_field('feature_header') ): ?>

				<?php 
					$project_path = get_field('project_path'); 
					$feature_path = $_SERVER['DOCUMENT_ROOT'].$project_path.'feature/';
					include($feature_path.get_field('feature_header'));
					echo "SERVER_ROOT: ".$_SERVER['DOCUMENT_ROOT'];
				?>

		<?php endif; ?>

	</head>
