<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package dev
 */

//get_header();

include(locate_template('header-project.php'));

?>

<body>
		
	<div id="container">

		<?php
			// Get Project Navigation
			get_template_part('nav-project');
		?>

		<section class="feature">
			<header class="feature">
				<img src="<?php bloginfo('template_directory'); ?>/images/cogs-large.png" class="logo" alt="two cogs - projects list" />
			</header>
		</section>

		<section class="project-archive">
		<?php if ( have_posts() ) : ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<article class="project-summary">
					<img src="<?php the_field('project_symbol'); ?>" class="symbol side" alt="symbol"/>
					<h3><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h3>
					
					<section class="project-info">
						<h5>Current Status</h5>
						<p><?php the_field('project_status'); ?></p>
					</section>		
			
					<p><?php the_field('project_synopsis'); ?></p>
				</article>

			<?php endwhile; ?>

		<?php else : ?>

			<?php get_template_part( 'no-results', 'archive' ); ?>

		<?php endif; ?>
		</section><!-- section.project-archive -->
	
	<?php
		// Get Project Footer
		include(locate_template('footer-project.php'));
	?>

	</div>

</body>

</html>