<?php
/**
 * The Template for displaying all single posts.
 *
 * @package dev-ac
 */

get_header(); ?>

	<section class="feature">

		<section class="feature-screenshot">
			<img src="<?php the_field('project_screenshot'); ?>" alt="<?php the_title(); ?> Screenshot" class="screenshot" />
		</section>

		<section class="feature-info">
			<?php if( have_rows('links') ): ?>
				<ul>
				<?php while( have_rows('links') ): the_row(); ?>
					<li><a href="<?php the_sub_field('link_address'); ?>" class="button dev-accent-hover"><?php the_sub_field('link_text'); ?></a></li>
				<?php endwhile; ?>
				</ul>
			<?php endif; ?>
		</section>

	</section> <!-- section.feature -->

</div> <!-- div.header-inner -->
</header>



	<section class="main">

		<?php while ( have_posts() ) : the_post(); ?>

			<article>
				
				<section class="project-logo">
					<img src="<?php the_field('project_logo'); ?>" class="logo" alt="logo" />
				</section>

				<section class="project-info">

					<span><i class="fa fa-tasks"></i> <?php the_field('project_status'); ?></span>

					<?php if( get_field('project_tools') ): ?>
					
						<ul>
							<?php $tools = get_field('project_tools'); ?>
							<?php foreach ($tools as $tool): ?>
								<li class="tool"><?php echo $tool->name ?></li>
							<?php endforeach; ?>
						</ul>

					<?php endif; ?>

				</section><!-- section.project-info -->

				<section class="project-content">

					<?php the_content(); ?>
					
				</section><!-- section.project-content -->

			</article> <!-- article -->
			
		<?php endwhile; // end of the loop. ?>

	</section> <!-- section.main -->

<?php //get_sidebar(); ?>
<?php get_footer(); ?>