<?php
/**
 * dev-ac functions and definitions
 *
 * @package dev-ac
 */

/**
 * Set OG Data
 */

function set_og_data()
{
	if( is_front_page() )
	{
		echo '<meta property="og:image" content="'.get_field('og_image').'"/>';
	}
}
add_action('wp_head', 'set_og_data');

/**
 * Set custom stylesheet
 */

function add_custom_stylesheet() {
	wp_register_style('custom', get_template_directory_uri() . '/custom.css', 'style');
}
add_action( 'wp_enqueue_scripts', 'add_custom_stylesheet' );

/**
 * Feature Main Setup
 */
function set_custom_css()
{
	$id = get_the_ID();

	// Front Page
	if( $id == get_option('page_on_front') )
	{
		set_custom_css_for_front_page($id);
	}
	// Single Project
	elseif( get_post_type($id) == 'projects' && is_single($id) )
	{
		set_custom_css_for_project($id);
	}
	// About
	elseif( is_page('about') || is_page('contact') )
	{
		set_custom_css_for_page($id);
	}

}
add_action( 'wp_enqueue_scripts', 'set_custom_css' );

function set_custom_css_for_front_page($id)
{
	$feature = get_post_meta($id, 'feature-main', true);

	set_custom_css_for_project($feature);

	$features = [['feature-1', 'li.focus-item:nth-child(1)'],
				 ['feature-2', 'li.focus-item:nth-child(2)'],
				 ['feature-3', 'li.focus-item:nth-child(3)']];

	foreach ($features as $feature)
	{
		$feature_sm = get_post_meta($id, $feature[0], true);

		$background = wp_get_attachment_image_src(get_post_meta($feature_sm, 'background_small', true),'full')[0];
		$color = "";

		setup_feature($background, $color, $feature[1]);
	}
}

function set_custom_css_for_project($id)
{
	$background = wp_get_attachment_image_src(get_post_meta($id, 'background_large', true),'full')[0];
	$color = get_post_meta($id, 'text_colour', true);
	$accent = get_post_meta($id, 'accent_colour', true);

	setup_header($background, $color, $accent);
}

function set_custom_css_for_page($id)
{
	$background = wp_get_attachment_image_src(get_post_meta($id, 'background_large', true),'full')[0];
	$color = get_post_meta($id, 'text_colour', true);
	$accent = get_post_meta($id, 'accent_colour', true);

	setup_header($background, $color, $accent);
}

function setup_header($background, $color, $accent)
{
	wp_enqueue_style('custom');
	$header_background_css = "";

	if($background)
	{
		$header_background_css = "header.main { background: url('$background'); }";
		wp_add_inline_style('custom', $header_background_css );
	}

	if($color)
	{
		$header_color_css = "header.main a { color: $color !important; opacity: 0.8; }";
		wp_add_inline_style('custom', $header_color_css );
	}

	if($accent)
	{
		$header_accent_css = ".dev-accent:hover, li.tool { background: $accent; } .dev-text, .dev-text:visited, article section p a, article section p a:visited { color: $accent; } .dev-accent-hover:hover { color: $accent !important; border-color: $accent !important; }";
		wp_add_inline_style('custom', $header_accent_css );
	}

}

function setup_feature($background, $color, $element)
{
	wp_enqueue_style('custom');
	$feature_background_css = "";

	if($background)
	{
		$feature_background_css = "$element { background: url('$background'); }";
	}

	wp_add_inline_style('custom', $feature_background_css );
}

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) )
	$content_width = 640; /* pixels */

if ( ! function_exists( 'dev_ac_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function dev_ac_setup() {

	/**
	 * Make theme available for translation
	 * Translations can be filed in the /languages/ directory
	 * If you're building a theme based on dev-ac, use a find and replace
	 * to change 'dev-ac' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'dev-ac', get_template_directory() . '/languages' );

	/**
	 * Add default posts and comments RSS feed links to head
	 */
	add_theme_support( 'automatic-feed-links' );

	/**
	 * Enable support for Post Thumbnails on posts and pages
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	//add_theme_support( 'post-thumbnails' );

	/**
	 * This theme uses wp_nav_menu() in one location.
	 */
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'dev-ac' ),
	) );

	/**
	 * Enable support for Post Formats
	 */
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link' ) );

	/**
	 * Setup the WordPress core custom background feature.
	 */
	add_theme_support( 'custom-background', apply_filters( 'dev_ac_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
}
endif; // dev_ac_setup
add_action( 'after_setup_theme', 'dev_ac_setup' );

/**
 * Register widgetized area and update sidebar with default widgets
 */
function dev_ac_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'dev-ac' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}
add_action( 'widgets_init', 'dev_ac_widgets_init' );

/**
 * Enqueue scripts and styles
 */
function dev_ac_scripts() {
	wp_enqueue_style( 'dev-ac-style', get_stylesheet_uri() );

	wp_enqueue_script( 'dev-ac-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );

	wp_enqueue_script( 'dev-ac-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	if ( is_singular() && wp_attachment_is_image() ) {
		wp_enqueue_script( 'dev-ac-keyboard-image-navigation', get_template_directory_uri() . '/js/keyboard-image-navigation.js', array( 'jquery' ), '20120202' );
	}
}
add_action( 'wp_enqueue_scripts', 'dev_ac_scripts' );


/**
 * Admin - Add Excerpt to Pages
 */
function add_excerpts_to_pages()
{
	add_post_type_support('page','excerpt');
}
add_action('init','add_excerpts_to_pages');

/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
