<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package dev-ac
 */

get_header(); ?>

		<section class="featured-project">
				<div class="inner-wrap">
					<?php $feature = get_field('feature-main'); ?>
					<section class="featured-project-image-mobile">
						<img src="<?php echo wp_get_attachment_image_src(get_post_meta($feature->ID, 'project_screenshot', true),'full')[0]; ?>" alt="<?php echo $feature->post_title; ?> Screenshot" class="screenshot" />
					</section>
					<section class="featured-project-info">
						<div class="logo-wrapper">
							<img src="<?php echo wp_get_attachment_image_src(get_post_meta($feature->ID, 'project_logo', true),'full')[0]; ?>" alt="<?php echo $feature->post_title; ?> Logo" class="logo" />
						</div>
						<p class="tagline"><?php echo get_post_meta($feature->ID, 'project_tagline', true); ?></p>
						<a href="<?php echo get_post_permalink($feature->ID) ?>" class="button dev-accent-hover">View Project</a>
					</section>
					<section class="featured-project-image">
						<img src="<?php echo wp_get_attachment_image_src(get_post_meta($feature->ID, 'project_screenshot', true),'full')[0]; ?>" alt="<?php echo $feature->post_title; ?> Screenshot" class="screenshot" />
					</section>
				</div>
		</section>

	</div> <!-- div.header-inner -->
</header>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<section class="focus">
				<!--<div class="divide dev-accent"></div>-->
				<ul class="focus-list">
					<li class="focus-item">
						<?php $feature = get_field('feature-1'); ?>
						<a href="<?php echo get_post_permalink($feature->ID) ?>">
							<div class="image-wrap">
								<img src="<?php echo wp_get_attachment_image_src(get_post_meta($feature->ID, 'project_screenshot', true),'full')[0]; ?>" alt="<?php echo $feature->post_title; ?> Symbol" class="" />
							</div>
							<h3><?php echo $feature->post_title; ?></h3>
							<p><?php echo get_post_meta($feature->ID, 'project_tagline', true); ?></p/>
						</a>
					</li>
					<li class="focus-item">
						<?php $feature = get_field('feature-2'); ?>
						<a href="<?php echo get_post_permalink($feature->ID) ?>">
							<div class="image-wrap">
								<img src="<?php echo wp_get_attachment_image_src(get_post_meta($feature->ID, 'project_screenshot', true),'full')[0]; ?>" alt="<?php echo $feature->post_title; ?> Symbol" class="" />
							</div>
							<h3><?php echo $feature->post_title; ?></h3>
							<p><?php echo get_post_meta($feature->ID, 'project_tagline', true); ?></p/>
						</a>
					</li>
					<li class="focus-item">
						<?php $feature = get_field('feature-3'); ?>
						<a href="<?php echo get_post_permalink($feature->ID) ?>">
							<div class="image-wrap">
								<img src="<?php echo wp_get_attachment_image_src(get_post_meta($feature->ID, 'project_screenshot', true),'full')[0]; ?>" alt="<?php echo $feature->post_title; ?> Symbol" class="" />
							</div>
							<h3><?php echo $feature->post_title; ?></h3>
							<p><?php echo get_post_meta($feature->ID, 'project_tagline', true); ?></p/>
						</a>
					</li>
				</ul>
			</section><!-- section.focus -->

			<section class="intro">
				<article>
					<?php echo $post->post_content; ?>
				</article><!-- article -->
			</section><!-- section.intro -->

		</main><!-- #main -->
	</div><!-- #primary -->

<?php //get_sidebar(); ?>
<?php get_footer(); ?>