<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package dev-ac
 */
?>
		<footer class="main">
			
			<div class="footer-inner">
				
				<?php if(!is_page('About') && !is_front_page()) : ?>
				<section class="about">

					<hr />
	
					<?php $about = get_page_by_path('about'); ?>
					<img src="<?php echo wp_get_attachment_image_src(get_post_meta($about->ID, 'header_image', true),'full')[0]; ?>" alt="Me" />
					<?php echo $about->post_excerpt; ?>

				</section>
				<?php endif; ?>

				<?php if(!is_front_page() && !is_page('Contact') && !is_page('About')): ?>
				<section class="contact">
					<?php $contact = get_page_by_path('contact'); ?>
					<?php echo $contact->post_excerpt; ?>
				</section>
				<?php endif; ?>

				<ul class="social">
					<?php $about = get_page_by_path('about'); ?>
					<li>
						<a href="<?php echo get_post_meta($about->ID, 'twitter')[0]; ?>">
							<img src="<?php echo get_bloginfo('template_directory').'/images/icon-twitter.png'; ?>" alt="Twitter Icon" />
						</a>
					</li>
					<li>
						<a href="<?php echo get_post_meta($about->ID, 'linkedin')[0]; ?>">
							<img src="<?php echo get_bloginfo('template_directory').'/images/icon-linkedin.png'; ?>" alt="LinkedIn Icon" />
						</a>	
					</li>
				</ul>

				<section class="legal">
					<p>Copyright 2014 &copy; Andrew Cobley</p>
				</section>
			</div>

		</footer>

</div><!-- #container -->

<?php wp_footer(); ?>

</body onload="prettyPrint()">
</html>