<?php
/**
 * Project Archive
 *
 * @package dev-ac
 */

get_header(); ?>

	</div> <!-- div.header-inner -->
</header>


	<section class="project-archive">
	<?php
		$the_query = new WP_Query(array('post_type' => 'projects', 'meta_key' => 'project_group', 'meta_value' => 'full'));
		if ( $the_query->have_posts() ) :
		
			/* Start the Loop */
			while ( $the_query->have_posts() ) : $the_query->the_post();
	?>

			<article class="project-summary">
				<section class="project-screenshot">
					<a href="<?php the_permalink(); ?>">
						<img src="<?php the_field('project_screenshot'); ?>" alt="screenshot" />
					</a>
				</section>

				<section class="project-info">
					<h3><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h3>
					<span><i class="fa fa-tasks"></i> <?php the_field('project_status'); ?></span>
					<?php if( get_field('project_tools') ): ?>
						<ul>
							<?php $tools = get_field('project_tools'); ?>
							<?php foreach ($tools as $tool): ?>
								<li class="tool" style="background: <?php the_field('accent_colour'); ?>;"><?php echo $tool->name ?></li>
							<?php endforeach; ?>
						</ul>
					<?php endif; ?>
				</section>		
		
				<section class="project-content">
					<p><?php the_field('project_synopsis'); ?></p>
				</section>
			</article>

		<?php endwhile; ?>
	<?php endif; ?>

	<h2>Other Projects</h2>

	<?php
		
		$the_query = new WP_Query(array('post_type' => 'projects', 'meta_key' => 'project_group', 'meta_value' => 'mini'));
		if ( $the_query->have_posts() ) :
		
			/* Start the Loop */
			while ( $the_query->have_posts() ) : $the_query->the_post();
	?>

			<article class="project-summary">
				<section class="project-info">
					<h3><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h3>
					<span><i class="fa fa-tasks"></i> <?php the_field('project_status'); ?></span>
				</section>		
		
				<section class="project-content">
					<p><?php the_field('project_synopsis'); ?></p>
				</section>
			</article>

		<?php endwhile; ?>
	<?php endif; ?>
	</section><!-- section.project-archive -->

<?php //get_sidebar(); ?>
<?php get_footer(); ?>
