/*!
 * TUMBLE-PROTOTYPE JS Methods
 * Copyright 2012, Andrew Cobley
 */

// Global Variables
var cnvs = document.getElementById('canvas');
var lastFrame = new Date().getTime();
var grav = -280;
var prvSuccess = false;

var plyr;
var brd;

var ground;

var pool;
var poolX = 150;
var poolY = 350;

// Input Variables
var md = false;
var mdX = 0;
var mdY = 0;

// Global Sounds
var sDizzy = new Audio('./assets/snd/dizzy-1.wav');
var sJump = new Audio('./assets/snd/jump-1.wav');
var sSplash = new Audio('./assets/snd/splash-1.wav');
var sSpring = new Audio('./assets/snd/spring-1.wav');
var sStep = new Audio('./assets/snd/step-1.wav');
var sThud = new Audio('./assets/snd/thud-1.wav');
var sWalk = new Audio('./assets/snd/walk-1.wav');

// Global Screen Adjustments
if(window.devicePixelRatio === 2)
{
	var adj = 2;
}
else
{
	var adj = 1;
}

// Check the element is in the DOM and the browser supports canvas
if(cnvs.getContext)
{
    // Initaliase a 2-dimensional drawing context
    var context = cnvs.getContext('2d');

    // Setup Player Game Object
    //var plyr = new Player();
    //plyr.init();

    // Setup Player!
    var plyr = new PlayerAlt();
    plyr.init();

    // Setup Board Game Object
    var brd = new Board();
    brd.init();

    // Setup Non Player!
    var np = new NonPlayer();
    np.init();

    // Setup Ground Image
    var ground = new Image();
    ground.src = './assets/img/ground.png';
    ground.onload = function()
    {
    	context.drawImage(ground, 0, 358);
    }

    // Setup Pool Image
    var pool = new Image();
    pool.src = './assets/img/pool.png';
    pool.onload = function()
    {
    	context.drawImage(pool, poolX, poolY);
    }

    // Setup Input
    input(); 

    // Start Game Loop
    var FPS = 30;
	setInterval(function() {
  		update();
  		draw();
	}, 1000/FPS);

}

function update()
{
	// Calculate the time since the last frame.
	var thisFrame = new Date().getTime();
	var delta = (thisFrame - lastFrame)/1000;
	lastFrame = thisFrame;

	// Update Game Objects
	plyr.update(delta);
	brd.update(delta);
	np.update(delta);
	
	if(plyr.climbing && prvSuccess)
	{
		if(!np.active)
		{
			np.walkTo(poolX-24);
		}

		if(np.x === (poolX-24))
		{
			var nValue = false;
			while(!nValue)
			{
				var nx = Math.floor(Math.random()*150) + 15;
				var dx = nx - poolX;
				if (dx <= -40  || dx >= 40)
				{
					nValue = true;
				}
			}
					
			np.walkTo(nx);
			np.pushing = true;
			prvSuccess = false;
		}
	}

}

function draw()
{
	// Clear Canvas
	context.clearRect(0, 0, cnvs.width, cnvs.height);

	// Render Game Objects
	brd.render();
	plyr.render();
	np.render();

	// Render Additional Images
	context.drawImage(ground, 0, 358);
    	context.drawImage(pool, poolX, poolY);
}

function input()
{

	/*$('html, body').on('touchstart touchmove', function(e)
	{ 
     	//prevent native touch activity like scrolling
     	e.preventDefault(); 
	});*/

    // Check for mouse press
    cnvs.onmousedown = function(e)
    {
    	mdX = e.pageX - cnvs.offsetLeft;
    	mdY = e.pageY - cnvs.offsetTop;
    	mousedown();
    }

    cnvs.addEventListener('touchstart', function(e)
    {
    	console.log('Touch Start!');
    	mdX = Math.floor(e.changedTouches[0].pageX - cnvs.offsetLeft) / adj;
    	mdY = Math.floor(e.changedTouches[0].pageY - cnvs.offsetTop) / adj;
    	e.preventDefault();
    	//alert("mdX: " + mdX + " mdY: " + mdY);
    	mousedown();
    });

    mousedown = function()
    {

    	console.log("Mouse Down: " + mdX + ", " + mdY);

		// Tidy this up!
		if( mdX >= 220 && mdX <= 292 && mdY >= 104 && mdY <= 116)
		{
			md = true;
		}
    }

    // Check for mouse move
    cnvs.onmousemove = function(e)
    {
    	var x = e.pageX - cnvs.offsetLeft;
    	var y = e.pageY - cnvs.offsetTop;
    	e.preventDefault();
    	mousemove(x,y);
    }

    cnvs.addEventListener('touchmove', function(e)
    {
    	console.log('Touch Move!');
    	var x = Math.floor(e.changedTouches[0].pageX - cnvs.offsetLeft) / adj;
    	var y = Math.floor(e.changedTouches[0].pageY - cnvs.offsetTop) / adj;
    	mousemove(x,y);
    });

    mousemove = function(x,y)
    {
	if(md)
	{
		//console.log("cX: " + x + " cY: " + y);
		var dy = y - mdY;

		if(dy < 20)
		{
			brd.animFrame = 5;
			if(plyr.ready)
			{
				plyr.setXY(plyr.ix, plyr.iy);
			}
		}
		else if(dy < 60)
		{
			brd.animFrame = 4;
			if(plyr.ready)
			{
				plyr.setXY(plyr.ix, (plyr.iy+1));
			}
		}
		else if(dy < 100)
		{
			brd.animFrame = 3;
			if(plyr.ready)
			{
				plyr.setXY(plyr.ix, (plyr.iy+2));
			}
		}
		else if(dy < 130)
		{
			brd.animFrame = 2;
			if(plyr.ready)
			{
				plyr.setXY(plyr.ix, (plyr.iy+3));
			}
		}
		else if(dy < 150)
		{
			brd.animFrame = 1;
			if(plyr.ready)
			{
				plyr.setXY(plyr.ix, (plyr.iy+4));
			}
		}
		else
		{
			brd.animFrame = 0;
			if(plyr.ready)
			{
				plyr.setXY(plyr.ix, (plyr.iy+5));
			}
		}

	}
    }

    // Check for mouse release
    cnvs.onmouseup = function(e)
    {
    	var x = e.pageX - cnvs.offsetLeft;
    	var y = e.pageY - cnvs.offsetTop;
    	mouseup(x,y);
    }

    cnvs.addEventListener('touchend', function(e)
    {
    	console.log('Touch End!');
    	var x = Math.floor(e.changedTouches[0].pageX - cnvs.offsetLeft) / adj;
    	var y = Math.floor(e.changedTouches[0].pageY - cnvs.offsetTop) / adj;
    	e.preventDefault();
    	mouseup(x,y);
    });

    mouseup = function(x,y)
    {
	if( md )
	{

		//console.log("MU cX: " + x + " cY: " + y);
		var dy = y - mdY;

		if(dy < 20)
		{
			// Do not recognise
		}
		else
		{	
			if(plyr.ready)
			{
				plyr.setVXVY( (x - mdX), (y - mdY) );
			}
			brd.active = true;
		}

	}
	md = false;
    }
}