function SplashSystem()

{

	this.x0;

	this.x1;

	this.y0;

	this.y1;


	this.n = 0;

	this.particles = [];

	this.gravity = 0;


	this.active = 0;



	this.init = function(n,x0,y0,x1,y1)

	{

		this.n = n;

		this.x0 = x0;

		this.x1 = x1;

		this.y0 = y0;

		this.y1 = y1;

		this.gravity = -100;

		this.active = n;

		
for(var i=0; i<n; i++)

		{

			//this.particles.push(new Particle());
			this.particles[i] = new Particle();

			this.particles[i].init(Math.floor(Math.random()*this.x1)+this.x0, Math.floor(Math.random()*this.y1)+this.y0, 0, -80, (x0 + ((x0-x1)/2)));

		}
	
}


	this.update = function(dt)

	{

		if(this.active > 0)

		{

			for(var i=0; i<this.particles.length; i++)

			{

				if(this.particles[i].dead === false)

				{

					if(this.particles[i].time < this.particles[i].life)

					{

						tmpX = this.particles[i].ix + (this.particles[i].vx * this.particles[i].time);

						tmpY = this.particles[i].iy + (this.particles[i].vy * this.particles[i].time) - (0.5 * this.gravity * Math.pow(this.particles[i].time,2));

						this.particles[i].time += dt;

						this.particles[i].vr = -1 * (Math.atan2(tmpX - this.particles[i].x, tmpY - this.particles[i].y) * (180/Math.PI) + 180);

						this.particles[i].x = tmpX;
 		
				this.particles[i].y = tmpY;

					}

					else

					{

						this.particles[i].dead = true;

						this.active--;
	
					}

				}

			}

		}

	}


	this.render = function()

	{

		if(this.active > 0)

		{

			for(var i=0; i<this.particles.length; i++)

			{

				if(this.particles[i].dead === false)

				{

					this.particles[i].render();

				}

			}

		}

	}


}