function PlayerAlt()

{

	
	this.x, this.y;

	this.ix, this.iy;

	this.vx, this.vy;

	this.rotation;


	this.img = new Image();


	this.diving = false;

	this.diveTime = 0;


	this.splash;

	

	this.init = function()
	
	{

		this.x = 280;

		this.y = 60;

		this.ix = this.x;

		this.iy = this.y;

		this.vx = 0;

		this.vy = 0;

		this.rotation = 0;


    		this.img.src = './assets/img/char-anim.png';

		
		this.animation = 0;
		this.animFrame = 0;
		this.animFrameWidth = 32;
		this.animFrameHeight = 48;
		this.animTime = 0;


		this.active = false;



		this.diving = false;

		this.diveTime = 0;


    		this.splash = new SplashSystem();




		this.diveEnding = false;
		this.diveSuccessful = false;
		this.diveNotSuccessful = false;


		this.walking = false;
		this.walkX = 0;
		this.walkDir = 0;
		
		this.climbing = false;
		this.climbTime = 0;

		this.jumping = false;
		this.jumpTime = 0;

		this.walkTo(212);

	}


	

	this.update = function(dt)

	{

		if(this.active)
		{
			if(this.walking)
			{
				this.walk(dt);
			}
			else if(this.jumping)
			{
				this.jump(dt);
			}
			else if(this.climbing)
			{
				this.climb(dt);
			}
			else if(this.diving)
			{
				this.dive(dt);
			}
			else if(this.diveEnding)
			{
				this.diveEnd(dt);
			}
			else if(this.diveSuccessful && this.splash.active <= 0)
			{
				this.successful(dt);
			}
			else if(this.diveNotSuccessful)
			{
				this.notSuccessful(dt);
			}
		}
		else
		{
			if(this.ix === 212 && this.iy === 60)
			{
				this.ready = true;
			}
			if(this.x === 280 && this.y === 310)
			{
				this.climbStart();
			}
		}

		if(this.splash.active > 0)
		{
			this.splash.update(dt);
		}
	}



	this.walkTo = function(x)
	{
		this.walkX = x;
		this.walking = true;	
		if( (x - this.x) < 0 )
		{
			this.walkDir = -1;
			this.animation = 2;
		}
		else
		{
			this.walkDir = 1;
			this.animation = 3;
		}
		this.animFrame = 0;
		this.animTime = 0;

		this.active = true;

	}

	this.walk = function(dt)
	{
		var x = this.x + (this.walkDir * (40 * dt));
		//console.log(this.walkDir + " >> x:" + x + " T: " + this.walkX);
		if(this.walkDir === -1 && x >= this.walkX || this.walkDir === 1 && x <= this.walkX)
		{
			this.x = x;
			this.animTime += dt;
			if(this.animTime > 0.2)
			{
				this.animFrame++;
				if(this.animFrame > 1)
				{
					this.animFrame = 0;
				}
				this.animTime = 0;

				sWalk.play();
			}
		}
		else
		{
			this.x = this.walkX;
			this.walking = false;
			this.active = false;
			console.log("Finished Walking!");
			this.animation = 0;
			this.animFrame = 0;
			this.setIXIY();
		}
	}

	this.jumpStart = function()
	{
		this.ix = this.x;
		this.iy = this.y;
		this.vx = 50;
		this.vy = -100;
		this.jumping = true;	
		this.active = true;

		sJump.play();
	}

	this.jump = function(dt)
	{
		this.jumpTime += dt;

		var x = this.getCX(this.jumpTime);

		var y = 
this.getCY(this.jumpTime);

		if(y <= 310)

		{

			this.x = x;

			this.y = y;

		}

		else

		{

			this.y = 310;

			if(this.jumpTime > 2.5)
			{
				this.jumpStop();
			}
		}

	}

	this.jumpStop = function()
	{
		this.jumpTime = 0;
		this.jumping = false;
		this.active = false;
		console.log("Jump finished!");
		this.walkTo(280);
	}

	this.climbStart = function()
	{
		this.animation = 1;
		this.animFrame = 0;
		this.animTime = 0;
		this.climbing = true;
		this.active = true;
	}

	this.climb = function(dt)
	{
		if(this.y > 60)
		{
			this.animTime += dt;			

			if(this.animTime > 0.15)
			{
				this.y -= 10;
				this.animFrame++;
				if(this.animFrame > 1)
				{
					this.animFrame = 0;
				}
				this.animTime = 0;

				sStep.play();
			}
		}
		else
		{
			// Pause at top of climb
			if(this.animTime < 0.5)
			{
				this.animation = 0;
				this.animFrame = 0;
				this.animTime += dt;
			}
			else
			{				
				console.log("Finished Climbing!");
				this.climbing = false;
				this.active = false;
				this.walkTo(212);
			}
		}
		
	}
	
	this.diveStart = function()
	{
		this.active = true;
		this.diving = true;
		this.ready = false;
		this.diveTime = 0;
		this.ix = this.x;
		this.iy = this.y;
	}	

	this.diveStop = function()
	{
		this.diving = false;
	}	

	this.dive = function(dt)
	{
		if(this.diveTime !== (this.diveTime + dt))
		{

			this.diveTime += dt;
	
			var x = this.getCX(this.diveTime);
	
			var y = this.getCY(this.diveTime);
			
			if(y <= 305)
	
			{
	
				this.rotation = -1 * (Math.atan2(x - this.x, y - this.y) * (180/Math.PI) + 180);
	
				console.log(this.rotation + " >> dt:" + this.diveTime + " >> nX:" + x + " X:" + this.x + " nY:" + y + " Y:" + this.y);
	
				this.x = x;
	
				this.y = y;
	
			}
	
			else
	
			{
	
				// Check if dive was a success
	
				if( (this.x + (this.animFrameWidth / 2)) >= (poolX + 5) && (this.x + (this.animFrameWidth / 2)) <= (poolX + pool.width - 3) )
				{
					// Dive was a success.
					this.diveStop();
					this.diveEnding = true;
					this.animFrame = 1;
	
					// Start Splash System
					this.splash.init(16,(poolX+2),349,(pool.width-2),5);
	
					sSplash.play();
	
				}
				else
				{
					// Dive was not successful - Reset
					this.y = 305;
	
					this.diveStop();
					this.diveTime = 0;
					this.diveNotSuccessful = true;
					sThud.play();
					// --> Animate Crash
				}
	
			}
		}
	}

	this.diveEnd = function(dt)
	{
		this.diveTime += dt;

		var x = this.getCX(this.diveTime);

		var y = 
this.getCY(this.diveTime);
		
		if(y <= 345)

		{

			this.rotation = -1 * (Math.atan2(x - this.x, y - this.y) * (180/Math.PI) + 180);
			this.x = x;

			this.y = y;

		}

		else
		{
			this.diveEnding = false;
			this.diveSuccessful = true;
			this.y = 345;
			this.x = (poolX + (pool.width / 2)) - (this.animFrameWidth / 2);
			this.rotation = 0;
		}
	}

	this.successful = function(dt)
	{
		if(this.y > 300)
		{
			this.y += (this.vy * dt);
		}
		else
		{
			this.y = 300;
			console.log("Dive Successful! :)");
			this.diveSuccessful = false;
			this.active = false;

			prvSuccess = true;

			this.jumpStart();
		}
	}


	this.notSuccessful = function(dt)
	{
		this.diveTime += dt;
		if(this.diveTime > 2)
		{			
			this.diveNotSuccessful = false;
			this.active = false;
			this.y = 310;
			this.rotation = 0;

			sDizzy.play();

			this.walkTo(280);
			console.log("Dive Not Successful :(");
		}
	}


	this.setXY = function(x,y)
	{
		this.x = x;
		this.y = y;
	}


	this.setVXVY = function(x,y)

	{

		this.vx = x * -2;

		this.vy = y * -3;

	}


	this.setIXIY = function(x,y)
	{
		this.ix = this.x;
		this.iy = this.y;
	}

	this.getCX = function(t)
	{
		return (this.ix + (this.vx * t));
	}

	this.getCY = function(t)
	{
		return (this.iy + ((this.vy * t) - (0.5 * grav * Math.pow(t,2))));
	}
	

	this.render = function()

	{

		context.save();

		context.translate(this.x + 16, this.y + 30);

		context.rotate(this.rotation*Math.PI/180);

		context.drawImage(this.img, (this.animFrame * this.animFrameWidth), (this.animation * this.animFrameHeight), this.animFrameWidth, this.animFrameHeight, -16, -30, this.animFrameWidth, this.animFrameHeight);

		context.restore();


		this.splash.render();


	}

}