function Player()

{

	
	this.x, this.y;

	this.ix, this.iy;

	this.vx, this.vy;

	this.rotation;


	this.img = new Image();


	this.diving = false;

	this.diveTime = 0;


	this.splash;

	

	this.init = function()
	
	{

		this.x = 212;

		this.y = 60;

		this.ix = this.x;

		this.iy = this.y;

		this.vx = 0;

		this.vy = 0;

		this.rotation = 0;


    		this.img.src = './assets/img/char.png';



		this.active = false;



		this.diving = false;

		this.diveTime = 0;


    		this.splash = new SplashSystem();




		this.diveEnding = false;
		this.diveSuccessful = false;
		this.diveNotSuccessful = false;


	}


	

	this.update = function(dt)

	{

		if(this.active)
		{
			if(this.diving)

			{

				this.dive(dt);
			}
			else if(this.diveEnding)
			{
				this.diveEnd(dt);
			}
			else if(this.diveSuccessful && !this.splash.active)
			{
				this.successful(dt);
			}
			else if(this.diveNotSuccessful)
			{
				this.notSuccessful(dt);
			}
		}
		if(this.splash.active)
		{
			this.splash.update(dt);
		}
	}


	this.diveStart = function()
	{
		this.active = true;
		this.diving = true;
	}	

	this.diveStop = function()
	{
		this.diving = false;
	}	

	this.dive = function(dt)
	{
		this.diveTime += dt;

		var x = this.getX();

		var y = 
this.getY();
		
		if(y <= 305)

		{

			this.rotation = -1 * (Math.atan2(x - this.x, y - this.y) * (180/Math.PI) + 180);

			this.x = x;

			this.y = y;

		}

		else

		{

			// Check if dive was a success

			if( (this.x + (this.img.width/2)) >= (poolX + 4) && (this.x + (this.img.width/2)) <= (poolX + pool.width - 4) )
			{
				// Dive was a success.
				this.diveStop();
				this.diveEnding = true;

				// Start Splash System

				this.splash.init(16,135,349,40,5);

			}
			else
			{
				// Dive was not successful - Reset
				this.y = 305;

				this.diveStop();
				this.diveNotSuccessful = true;
				// --> Animate Crash
			}

		}

	}

	this.diveEnd = function(dt)
	{
		this.diveTime += dt;

		var x = this.getX();

		var y = 
this.getY();
		
		if(y <= 345)

		{

			this.rotation = -1 * (Math.atan2(x - this.x, y - this.y) * (180/Math.PI) + 180);

			this.x = x;

			this.y = y;

		}

		else
		{
			this.diveEnding = false;
			this.diveSuccessful = true;
			this.y = 345;
			this.x = (poolX + (pool.width / 2)) - (this.img.width / 2);
			this.rotation = 0;
		}
	}

	this.successful = function(dt)
	{
		if(this.y > 310)
		{
			this.y += (this.vy * dt);
		}
		else
		{
			console.log("Dive Successful!");
			this.active = false;
		}
	}


	this.notSuccessful = function(dt)
	{
		console.log("Dive Unsuccessful!");
		this.active = false;
	}


	this.setVXVY = function(x,y)

	{

		this.vx = x * -1;

		this.vy = y * -1;

	}


	this.getX = function()
	{
		return (this.ix + (this.vx * this.diveTime));
	}

	this.getY = function()
	{
		return (this.iy + ((this.vy * this.diveTime) - (0.5 * grav * Math.pow(this.diveTime,2))));
	}
	

	this.render = function()

	{

		context.save();

		context.translate(this.x + 16, this.y + 30);

		context.rotate(this.rotation*Math.PI/180);

		context.drawImage(this.img, -16, -30);

		context.restore();


		this.splash.render();


	}

}