function NonPlayer()

{

	
	this.x, this.y;

	this.ix, this.iy;

	this.vx, this.vy;

	this.rotation;


	this.img = new Image();



	this.init = function()
	
	{

		this.x = -100;

		this.y = 310;

		this.ix = this.x;

		this.iy = this.y;

		this.vx = 0;

		this.vy = 0;

		this.rotation = 0;


    		this.img.src = './assets/img/char-2-anim.png';

		
		this.animation = 0;
		this.animFrame = 0;
		this.animFrameWidth = 32;
		this.animFrameHeight = 48;
		this.animTime = 0;


		this.active = false;


		this.walking = false;
		this.walkX = 0;
		this.walkDir = 0;

		this.pushing = false;

		this.walkTo(5);

	}


	

	this.update = function(dt)

	{

		if(this.active)
		{
			if(this.walking)
			{
				this.walk(dt);
			}
		}
		else
		{
			if(this.x === (poolX - 24) && !prvSuccess && !this.pushing)
			{
				this.walkTo(5);
			}
		}
	}



	this.walkTo = function(x)
	{
		this.walkX = x;
		this.walking = true;	
		if( (x - this.x) < 0 )
		{
			this.walkDir = -1;
			this.animation = 2;
		}
		else
		{
			this.walkDir = 1;
			this.animation = 1;
		}
		this.animFrame = 0;
		this.animTime = 0;

		this.active = true;

	}

	this.walk = function(dt)
	{
		var x = this.x + (this.walkDir * (40 * dt));
		//console.log(this.walkDir + " >> x:" + x + " T: " + this.walkX);
		if(this.walkDir === -1 && x >= this.walkX || this.walkDir === 1 && x <= this.walkX)
		{
			this.x = x;
			if(this.pushing)
			{
				poolX = (x + 24);
			}
			this.animTime += dt;

			if(this.animTime > 0.2)
			{
				this.animFrame++;
				if(this.animFrame > 1)
				{
					this.animFrame = 0;
				}
				this.animTime = 0;

				console.log("A: " + this.animFrame);

				sWalk.play();
			}
		}
		else
		{
			this.x = this.walkX;
			if(this.pushing)
			{
				poolX = (this.walkX + 24);
			}
			this.walking = false;
			this.pushing = false;
			this.active = false;
			console.log("Finished Walking!");
			this.animation = 0;
			this.animFrame = 0;
			this.setIXIY();
		}
	}


	this.setXY = function(x,y)
	{
		this.x = x;
		this.y = y;
	}

	this.setIXIY = function(x,y)
	{
		this.ix = this.x;
		this.iy = this.y;
	}
	

	this.render = function()

	{

		context.save();

		context.translate(this.x + 16, this.y + 30);

		context.rotate(this.rotation*Math.PI/180);

		context.drawImage(this.img, (this.animFrame * this.animFrameWidth), (this.animation * this.animFrameHeight), this.animFrameWidth, this.animFrameHeight, -16, -30, this.animFrameWidth, this.animFrameHeight);

		context.restore();


	}

}