/*!
 * TRIP-PROTOTYPE
 * CORE GOOGLE MAPS JS Methods
 * Copyright 2014, Andrew Cobley
 */

// ##########################
// INIT GOOGLE MAPS VARIABLES

google.maps.visualRefresh = true;

var map;
var mapOp;
var maptype_id = google.maps.MapTypeId.ROADMAP;

var place_markers = {};
var tmpMarker;
var curMarker;

var styles = [
	{featureType:"all",elementType:"all",stylers:[{saturation:-50}]},
	{featureType:"transit",elementType:"all",stylers:[{visibility:"off"}]},
	{featureType:"road",elementType:"all",stylers:[{visibility:"on"}]},
	{featureType:"road.highway",elementType:"all",stylers:[{visibility:"on"}]},
	{featureType:"poi",elementType:"all",stylers:[{visibility:"on"}]}
];

function initializeMap(lat,lng,zoom) 
{
	// SET MAP CENTER AND ZOOM LEVEL
	var center = new google.maps.LatLng(lat,lng);
	var zoom = zoom;

	// SET MAP OPTIONS
	mapOp = {
		center: center,
		zoom: zoom,
		panControl: false,
		zoomControl: true,
		zoomControlOptions: {
			style: google.maps.ZoomControlStyle.SMALL,
		},
		scaleControl: true,
		streetViewControl: false,
		mapTypeId: maptype_id
	};

	// SET MAP
	map = new google.maps.Map(document.getElementById("map"),mapOp);

	// STYLE MAP
	var styledMapOp = {
		name: 'Styled'
	};

	var customMapType = new google.maps.StyledMapType(styles, styledMapOp);

	map.mapTypes.set(maptype_id, customMapType);

}

var mapPanTo = function(geolat, geolng, zoom)
{
	var latLng = new google.maps.LatLng(geolat, geolng);
	map.panTo(latLng);
	map.setZoom(zoom);
}

var mapAddPlaceMarker = function(geolat, geolng, id, name)
{
	var latLng = new google.maps.LatLng(geolat, geolng);

	var marker = new google.maps.Marker(
	{
		position: latLng,
		map: map,
		id: id,
		title: name
	});

	place_markers[id] = marker;
}

var addLocationToMap = function()
{
	tmpMarker = new google.maps.Marker(
	{
	    map: map,
	    draggable: true
	});

	google.maps.event.addListenerOnce(map, 'click', function(event)
	{
		console.log(event);
		placeMarker(event.latLng);
		//updateLocationButton('Reset Map Location');
		updateGeoCoords(event.latLng.lat().toFixed(6),event.latLng.lng().toFixed(6));
	});

	google.maps.event.addListener(tmpMarker, 'drag', function(event)
	{
		updateGeoCoords(event.latLng.lat().toFixed(6),event.latLng.lng().toFixed(6));
	});
	
	function placeMarker(location)
	{
		tmpMarker.setPosition(location);
	}
}

var setMarkerUnlocked = function(id)
{
	var curMarker = new google.maps.Marker();
	curMarker = place_markers[id];
	curMarker.setDraggable(true);
}

var setMarkerLocked = function(id)
{
	var curMarker = new google.maps.Marker();
	curMarker = place_markers[id];
	curMarker.setDraggable(false);
}

var setAllMarkersLocked = function()
{
	for(var marker in place_markers)
	{
		place_markers[marker].setDraggable(false);
	}
}

var setMarkerToOrigin = function(id, geolat, geolng)
{
	var curMarker = new google.maps.Marker();
	curMarker = place_markers[id];

	var latLng = new google.maps.LatLng(geolat, geolng);

	curMarker.setPosition(latLng);
}

var mapRemoveTempMarker = function()
{
	if(tmpMarker)
	{
		tmpMarker.setMap(null);
	}
}

var indicateMarkerStart = function(id)
{
	var curMarker = new google.maps.Marker();

	if(id == 'tmp')
	{
		curMarker = tmpMarker;
	}
	else
	{
		curMarker = place_markers[id];
	}

	console.log(id);

	curMarker.setAnimation(google.maps.Animation.BOUNCE);
}

var indicateMarkerStop = function(id)
{
	var curMarker = new google.maps.Marker();

	if(id == 'tmp')
	{
		curMarker = tmpMarker;
	}
	else
	{
		curMarker = place_markers[id];
	}

	curMarker.setAnimation(null);
}
