$(function()
{
	//var notes_scroll = $('.notes').jScrollPane({mouseWheelSpeed: 500, verticalGutter: 10});

	// SIDE MENU BUTTON
	$(document).on('click','div.side-menu-button',function()
	{
		openSideMenu();
	});

	// ICON MENU BUTTON - TEMP
	$(document).on('click','span.icon-menu',function()
	{
		closeSideMenu();
	});



	// MENU > AREA EVENTS
	$(document).on('click','ul.area li.area-header',function()
	{
		var el = $(this);
		var toggle = 'ul.type';
		toggleMenu(el, toggle);
	});

	$(document).on('click', '.area-edit', function(e)
	{
		// Change Background of active element.
		e.stopPropagation();
		var id = $(this).closest('.area-header').data('area-id');
		editAreaForID(id);
	});

	$(document).on('click', '.area-delete', function(e)
	{
		// Show delete confirmation.
		e.stopPropagation();
		$(this).next('.delete-confirm-group').fadeIn('250');
	});

	$(document).on('click', '.area-delete-confirm', function(e)
	{
		e.stopPropagation();
		var id = $(this).closest('li.area-header').data('area-id');
		deleteAreaForID(id);
		$(this).parent('.delete-confirm-group').fadeOut('250');
	});

	$(document).on('click', '.area-delete-cancel', function(e)
	{
		e.stopPropagation();
		$(this).parent('.delete-confirm-group').fadeOut('250');
	});


	// MENU > TYPE EVENTS
	$(document).on('click','ul.type li.type-header',function()
	{
		var el = $(this);
		var toggle = 'ul.place';
		toggleMenu(el, toggle);
	});


	// MENU > PLACE EVENTS
	$(document).on('click','ul.place li',function()
	{
		var el = $(this);
		// Change Background of active element.
		$('ul.place li').removeClass('place-active');
		el.addClass('place-active');

		var place = el.children('h2').text();
		console.log(place);

		var geolat = el.data('place-geolat');
		var geolng = el.data('place-geolng');

		var id = el.data('place-id');

		placeSelected(id, geolat, geolng);
	});

	$(document).on('click', '.place-edit', function(e)
	{
		e.stopPropagation();
		var el = $(this);

		var id = el.closest('.place-header').data('place-id');
		var geolat = el.closest('.place-header').data('place-geolat');
		var geolng = el.closest('.place-header').data('place-geolng');

		mapPanTo(geolat, geolng, 17);

		console.log(id);

		editPlaceForID(id);
	});

	$(document).on('click', '.place-delete', function(e)
	{
		// Show delete confirmation.
		e.stopPropagation();
		$(this).next('.delete-confirm-group').fadeIn('250');
	});

	$(document).on('click', '.place-delete-confirm', function(e)
	{
		e.stopPropagation();
		var id = $(this).closest('li.place-header').data('place-id');
		deletePlaceForID(id);
		$(this).parent('.delete-confirm-group').fadeOut('250');
	});

	$(document).on('click', '.place-delete-cancel', function(e)
	{
		e.stopPropagation();
		$(this).parent('.delete-confirm-group').fadeOut('250');
	});


	// MENU > TRIP OPTIONS

	$(document).on('click','span.icon-trip-settings', function()
	{
		$(this).parent().next('div.trip-options').slideToggle('slow', function()
		{
			updateMenuHeight();
		});
	});

	$(document).on('click','div.trip-options ul.options li', function()
	{
		var menu = $(this).data('menu');
		$('ul.trip-option.' + menu).slideToggle('slow', function()
		{
			updateMenuHeight();
		});
	});


	// >>> ADD NEW AREA
	$(document).on('click','li#trip-menu-add-new-area', function()
	{
		displayAddNewArea();	
	});

	// >>> ADD NEW PLACE
	$(document).on('click','li#trip-menu-add-new-place', function()
	{
		displayAddNewPlace();
	});



	// CREATE AREA

	$(document).on('click','li.cancel-area-form', function()
	{
		cancelAreaForm();
	});



	// ADD PLACE

	// >>> ADD MAP LOCATION
	$(document).on('click','button.add-place-location', function()
	{
		addLocationToMap();
	});

	// >>> CANCEL ADD PLACE
	$(document).on('click','li.cancel-place-form', function()
	{
		var el = $(this);
		var id = el.data('id') ? el.data('id') : 'tmp';
		var olat = el.data('oldlat') ? el.data('oldlat') : '';
		var olng = el.data('oldlng') ? el.data('oldlng') : '';

		cancelPlaceForm(id, olat, olng);
	});

	// >>> GO TO MAP LOCATION
	$(document).on('click','div.place-geo-coords', function()
	{
		var el = $(this);
		var lat = el.data('lat');
		var lng = el.data('lng');
		console.log(lat + ", " + lng);
		mapPanTo(lat,lng,17);
	});

	// >>> INDICATE MARKER ON MAP
	$(document).on(
	{
    	mouseenter: function()
    	{
    		var el = $(this);
    		var id = el.data('place-id') ? el.data('place-id') : 'tmp';
    		indicateMarkerStart(id);
    	},
    	mouseleave: function()
    	{
    		var el = $(this);
    		var id = el.data('place-id') ? el.data('place-id') : 'tmp';
			indicateMarkerStop(id);
    	}
	}, '.edit-place-location-wrapper');


	// >>> EDIT LINK > TOGGLE
	$(document).on('click','span.icon-link-edit', function()
	{
		if( $(this).children('i').hasClass('fa-chevron-circle-right') )
		{
			// Open Toggle
			$(this).children('i').removeClass('fa-chevron-circle-right');
			$(this).children('i').addClass('fa-chevron-circle-down');

			$(this).next('div.edit-link-group-expand').slideDown('medium', function(){});
		}
		else
		{
			// Shut Toggle
			$(this).children('i').removeClass('fa-chevron-circle-down');
			$(this).children('i').addClass('fa-chevron-circle-right');

			$(this).next('div.edit-link-group-expand').slideUp('medium', function(){});
		}
	});


	// >>> EDIT ATTACHMENT > TOGGLE
	$(document).on('click','span.icon-attachment-edit', function()
	{
		if( $(this).children('i').hasClass('fa-chevron-circle-right') )
		{
			// Open Toggle
			$(this).children('i').removeClass('fa-chevron-circle-right');
			$(this).children('i').addClass('fa-chevron-circle-down');

			$(this).next('div.edit-attachment-group-expand').slideDown('medium', function(){});
		}
		else
		{
			// Shut Toggle
			$(this).children('i').removeClass('fa-chevron-circle-down');
			$(this).children('i').addClass('fa-chevron-circle-right');

			$(this).next('div.edit-attachment-group-expand').slideUp('medium', function(){});
		}
	});

	// >>> DELETE CONFIRMATION EXPAND
	$(document).on('click','span.icon-delete', function()
	{
		$(this).nextAll('div.delete-confirmation-expand').fadeIn('medium', function(){});
	});

	// >>> DELETE CONFIRMATION
	$(document).on('click','.button-delete', function()
	{
		$(this).fadeOut('fast', function()
		{
			$(this).nextAll('div.button-delete-confirmation-group').fadeIn('fast', function(){});
		});
	});

	// >>> CANCEL CONFIRMATION
	$(document).on('click','span.delete-cancel', function()
	{
		$(this).parent('div.delete-confirmation-expand').fadeOut('medium', function(){});
	});



	$('.button-delete-cancel').click(function()
	{
		$(this).parent('div.button-delete-confirmation-group').fadeOut('fast', function()
		{
			$(this).prevAll('.button-delete').fadeIn('fast', function(){});
		});
	});

	// >>> HIDE PLACE ENTRY
	$(document).on('click','.place-info-close', function()
	{
		console.log('place info click!');
		hidePlaceInfo();
	});

});

var refreshScroll = function(el)
{
	el.data('jsp').reinitialise();
}



var setupDirectory = function()
{
	updateMenuHeight();
	directoryScroll = new IScroll('#areas-scroll-wrap', 
	{
		fadeScrollbars: false,
		scrollbars: 'custom'
	});
}




// SHUT TOGGLE
// ARG 1 - Clicked Element
// ARG 2 - Element to Toggle
var toggleMenu = function(el, toggleEl)
{
	if( el.children('span.icon-wrap-toggle').hasClass('icon-toggle-shut') && el.next().is(toggleEl) )
	{
		// Open Toggle
		el.children('span.icon-wrap-toggle').removeClass('icon-toggle-shut');
		el.children('span.icon-wrap-toggle').addClass('icon-toggle-open');
		el.next(toggleEl).show('medium', function(){});
	}
	else
	{
		// Shut Toggle
		el.children('span.icon-wrap-toggle').removeClass('icon-toggle-open');
		el.children('span.icon-wrap-toggle').addClass('icon-toggle-shut');
		el.next(toggleEl).hide('medium', function(){});
	}
}

// SETUP MAP FOR TRIP
// ARG 1 - TRIP SCOPE
var setMapForTrip = function(trip)
{
	//console.log("HERE: Map Pan");
    //mapPanTo(trip.base_location.geolat, trip.base_location.geolng, trip.base_zoom);
	google.maps.event.addDomListener(window, 'load', initializeMap(trip.base_location.geolat, trip.base_location.geolng, trip.base_zoom));
    //console.log("HERE: Get Places");
    var places = getPlacesForTrip(trip);
    setMarkersForPlaces(places);
}

// GET ALL PLACES FROM TRIP MENU
// ARG 1 - TRIP SCOPE
// RETURN - PLACE ARRAY
var getPlacesForTrip = function(trip)
{
	var places = [];

	for (var a = 0; a < trip.areas.length; a++)
	{
		var area = trip.areas[a];

		for (var t = 0; t < area.types.length; t++)
		{
			var type = area.types[t];
			
			if (type.places)
			{
				for (var p = 0; p < type.places.length; p++)
				{
					var place = type.places[p];

					places.push({
						id: place.id,
						name: place.name,
						type: type.name,
						geolat: place.location.geolat,
						geolng: place.location.geolng
					});
				}
			}
		}
	}

	return places;
}

// SET MARKERS FOR PLACES
// ARG 1 - PLACE ARRAY
var setMarkersForPlaces = function(places)
{
	for (var p = 0; p < places.length; p++)
	{
		var place = places[p];
		mapAddPlaceMarker(place);
	}
}



// EDIT AREA FUNCTIONS >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

// EDIT AREA FOR ID
// ARG 1 - AREA ID
var editAreaForID = function(id)
{
	removeOtherWindows();
	var t = window.setTimeout(function()
	{
		angular.element($('#edit-area')).scope().setupEditForArea(id);
	}, 500);
}

// AREA EDIT COMPLETE
var areaEditSetupComplete = function()
{
	$('div.edit.area').fadeIn(500);
}

// EDIT AREA COMPLETE 
var areaEditComplete = function()
{
	$('div.edit.area main form ul div.complete').fadeIn(500).delay(1500).queue(function()
	{
		$(this).dequeue();
		fadeEditArea();
	})

	var fadeEditArea = function()
	{
		$('div.edit.area').fadeOut(1000, function()
		{
			$('div.edit.area main form ul div.complete').fadeOut(10);
			angular.element($('#edit-area')).scope().reset();
		});
	}

}

// DELETE AREA FUNCTIONS >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

// DELETE AREA FOR ID
// ARG 1 - AREA ID
var deleteAreaForID = function(id)
{
	angular.element($('#trip-wrapper')).scope().deleteArea(id);
}


// EDIT PLACE FUNCTIONS >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

// EDIT PLACE FOR ID
// ARG 1 - PLACE ID
var editPlaceForID = function(id)
{
	console.log(id);
	removeOtherWindows();
	var t = window.setTimeout(function()
	{
		angular.element($('#edit-place')).scope().setupEditForPlace(id);
	}, 500);
}

// PLACE EDIT SETUP COMPLETE
var placeEditSetupComplete = function(id)
{
	$('div.edit.place').fadeIn(500);
	setMarkerUnlocked(id);
}

// EDIT PLACE COMPLETE 
var placeEditComplete = function(id)
{
	$('div.edit.place main form ul div.complete').fadeIn(500).delay(1500).queue(function()
	{
		$(this).dequeue();
		fadeEditPlace();
		setMarkerLocked(id);
	})

	var fadeEditPlace = function()
	{
		$('div.edit.place').fadeOut(1000, function()
		{
			$('div.edit.place main form ul div.complete').hide();
			angular.element($('#edit-place')).scope().reset();
		});

	}

}

// DELETE PLACE FUNCTIONS >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

// DELETE PLACE FOR ID
// ARG 1 - PLACE ID
var deletePlaceForID = function(id)
{
			console.log(id);

	angular.element($('#trip-wrapper')).scope().deletePlace(id);
}


// CREATE AREA COMPLETE 
var newAreaAdded = function(places)
{
	$('div.create.area main form ul div.complete').fadeIn(500).delay(1500).queue(function()
	{
		fadeCreateArea();
	});

	var fadeCreateArea = function()
	{
		$('div.create.area').fadeOut(500, function()
		{
			angular.element($('#add-new-area')).scope().reset();
			resetForm( $('div.create.area').find('form') );
		});
	}

}



// CREATE PLACE COMPLETE 
var newPlaceAdded = function(place)
{
	console.log('New Place Added!');

	$('div.create.place main form ul div.complete').fadeIn(500).delay(1500).queue(function()
	{
		fadeCreatePlace(place);
	});

	var fadeCreatePlace = function(place)
	{
		$('div.create.place').fadeOut(500, function()
		{
			angular.element($('#add-new-place')).scope().reset();
			resetForm( $('div.create.place').find('form') );
			placeSelected(place[0], place[1], place[2]);
		});
	}

	var goToNewPlace = function(place)
	{
		placeSelected(place[0], place[1], place[2]);
	}

}

// CREATE PLACE COMPLETE 
var placeSelected = function(id, geolat, geolng)
{
	removeOtherWindows();
	var t = window.setTimeout(function()
	{
    	mapPanTo(geolat, geolng, 17);
		angular.element($('#place-entry')).scope().getPlaceEntryForID(id);
	}, 500);
}

var showPlaceInfo = function()
{
	if( $('#place-entry').not(':visible') ) $('#place-entry').fadeIn(500);
}

var hidePlaceInfo = function()
{
	if( $('#place-entry').is(':visible') ) $('#place-entry').fadeOut(500);
}


// CANCEL AREA FORM
var cancelAreaForm = function()
{
	var el = $('div.area.form');
	var form = $('form.form-area');

	cancelFormAndReset(el,form);
}

// CANCEL PLACE FORM
var cancelPlaceForm = function(id, lat, lng)
{
	var el = $('div.place.form');
	var form = $('form.form-place');

	if(id == 'tmp')
	{
		mapRemoveTempMarker();
	}
	else
	{
		// Reset Marker to Original Position 
		setMarkerToOrigin(id,lat,lng);
		setMarkerLocked(id);
	}

	cancelFormAndReset(el,form);
}

// FADE GIVEN FORM AND CALL RESET ON COMPLETION
// ARG 1 - FORM CONTAINER ELEMENT
// ARG 2 - FORM ELEMENT
var cancelFormAndReset = function(el,form)
{
	el.fadeOut(500, function()
	{
		resetForm(form);
	});
}

// RESET THE GIVEN FORM
// ARG 1 - FORM ELEMENT
var resetForm = function(form)
{
	console.log("Reset Form!");
	form.find('div.complete').hide();

	form[0].reset();

	if( form.hasClass('form-place') )
	{
		resetFormPlace(form);
	}
}

// RESET THE FORM PLACE
// ARG 1 - FORM ELEMENT
var resetFormPlace = function(form)
{
	angular.element($('#add-new-place')).scope().reset();
}


// UPDATE GEO-COORDS
// ARG 1 - GEOLAT
// ARG 2 - GEOLNG
var updateGeoCoords = function(geolat, geolng)
{
	//$('div.place-geo-coords span.geolat').text(geolat);
	//$('div.place-geo-coords span.geolng').text(geolng);
	angular.element($('#add-new-place')).scope().updatePlaceGeoCoords(geolat,geolng);
}



// !!!! NEEDS A MORE ELEGENT SOLUTION - FINE FOR NOW
// REMOVE OTHER WINDOWS FROM SCREEN
// ARG 1 - FORM ELEMENT
var removeOtherWindows = function()
{
	if( $('.area.form').is(':visible') ) $('.area.form').fadeOut(500);
	if( $('.place.form').is(':visible') ) $('.place.form').fadeOut(500);
	if( $('#place-entry').is(':visible') ) $('#place-entry').fadeOut(500);
}

var displayAddNewArea = function()
{
		removeOtherWindows();
		var t = window.setTimeout(function()
		{
    		$('div.create.area').fadeIn(500);
		}, 500);
}

var displayAddNewPlace = function()
{
		removeOtherWindows();
		var t = window.setTimeout(function()
		{
			console.log('Fade in place...');
    		$('div.create.place').fadeIn(500);
		}, 500);
}


// OPEN THE SIDE MENU
var openSideMenu = function()
{
	var mapCenter = map.getCenter();
	console.log(mapCenter);

	$('div.trip-map-wrapper').animate({ 'paddingLeft': '20em' }, 500);

	var timer = setInterval(function()
			{ 
				google.maps.event.trigger(map, 'resize');
				map.setCenter(mapCenter);
				console.log('MAP TIMER');
			}, 50);

	$('div.side-menu').animate({ 'marginLeft': '0' }, 500, function()
	{
		var timerMap = clearInterval(timer);
		google.maps.event.trigger(map, 'resize'); 
		map.setCenter(mapCenter);
		$('div#zoom-control').animate({ top: '0' }, 200);
	});
	console.log(map.getCenter());
}

// CLOSE THE SIDE MENU
var closeSideMenu = function()
{
	var mapCenter = map.getCenter();
	console.log(mapCenter);

	$('div.trip-map-wrapper').animate({ 'paddingLeft': '0' }, 500);

	var timer = setInterval(function()
				{ 
					google.maps.event.trigger(map, 'resize');
					map.setCenter(mapCenter);
					console.log('MAP TIMER');
				}, 50);

	$('div.side-menu').animate({ 'marginLeft': '-20em' }, 500, function()
	{
		var timerMap = clearInterval(timer);
		google.maps.event.trigger(map, 'resize'); 
		map.setCenter(mapCenter);
		$('div#zoom-control').animate({ 'top': '4.5em' }, 200);
	});
}

// MENU HEIGHT UPDATE
//$("body").on("updateMenuHeight",function(e)
var updateMenuHeight = function()
{
	var full_height = $('div.side-menu').height();
	var header_height = $('div.side-menu header').is(":visible") ? $('div.side-menu header').height() : 0;
	var trip_header_height = $('div.trip-header').is(":visible") ? $('div.trip-header').height() : 0;
	var trip_options_height = $('div.trip-options').is(":visible") ? $('div.trip-options').height() : 0;

	var height = full_height - header_height - trip_header_height - trip_options_height;

	$('ul.area').height(height);
	console.log(full_height + " - " + header_height + " - " + trip_header_height + " - " + trip_options_height + " = " + height);
}


// WINDOW RESIZE
$(window).resize(function()
{
	updateMenuHeight();
});
