-- phpMyAdmin SQL Dump
-- version 4.1.8
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Jul 10, 2014 at 11:25 AM
-- Server version: 5.5.36-cll
-- PHP Version: 5.4.23

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `gogoracc_ac_trip`
--

-- --------------------------------------------------------

--
-- Table structure for table `areas`
--

CREATE TABLE IF NOT EXISTS `areas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `additional` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trip_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `areas_trip_id_foreign` (`trip_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `areas`
--

INSERT INTO `areas` (`id`, `name`, `additional`, `trip_id`, `created_at`, `updated_at`) VALUES
(1, 'San Francisco', '04 May - 09 May', 1, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(2, 'Portland', '10 May - 15 May', 1, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(3, 'San Francisco', '04 May - 11 May', 3, '2014-07-07 10:04:43', '2014-07-07 10:04:43');

-- --------------------------------------------------------

--
-- Table structure for table `attachments`
--

CREATE TABLE IF NOT EXISTS `attachments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `place_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `attachments_place_id_foreign` (`place_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `attachments`
--

INSERT INTO `attachments` (`id`, `name`, `address`, `place_id`, `created_at`, `updated_at`) VALUES
(1, 'Free Beer Voucher', 'http://www.google.co.uk', 1, '2014-07-07 10:04:42', '2014-07-07 10:04:42');

-- --------------------------------------------------------

--
-- Table structure for table `links`
--

CREATE TABLE IF NOT EXISTS `links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `place_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `links_place_id_foreign` (`place_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `links`
--

INSERT INTO `links` (`id`, `name`, `address`, `place_id`, `created_at`, `updated_at`) VALUES
(1, 'Official Website', 'http://21st-amendment.com/', 1, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(2, 'Official Website', 'http://www.anchorbrewing.com/', 2, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(3, 'Tickets', 'http://www.alcatrazcruises.com/', 4, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(4, 'Mayflower Website', 'http://www.sfmayflowerhotel.com/', 9, '2014-07-08 10:44:56', '2014-07-08 10:44:56'),
(5, 'The Sea Lion Story', 'http://www.pier39.com/home/the-sea-lion-story/', 11, '2014-07-09 16:59:57', '2014-07-09 16:59:57');

-- --------------------------------------------------------

--
-- Table structure for table `locations`
--

CREATE TABLE IF NOT EXISTS `locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `geolat` decimal(9,6) NOT NULL,
  `geolng` decimal(9,6) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=28 ;

--
-- Dumping data for table `locations`
--

INSERT INTO `locations` (`id`, `geolat`, `geolng`, `created_at`, `updated_at`) VALUES
(1, '44.312639', '-122.282252', '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(2, '37.782456', '-122.392564', '2014-07-07 10:04:42', '2014-07-09 17:33:25'),
(3, '37.763398', '-122.401413', '2014-07-07 10:04:42', '2014-07-09 17:35:10'),
(4, '45.521624', '-122.691670', '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(5, '37.827220', '-122.422956', '2014-07-07 10:04:42', '2014-07-09 17:27:34'),
(6, '37.798113', '-122.395494', '2014-07-07 10:04:43', '2014-07-07 10:04:43'),
(7, '37.752338', '-122.199238', '2014-07-07 10:04:43', '2014-07-09 17:37:10'),
(8, '37.778889', '-122.389729', '2014-07-07 10:04:43', '2014-07-09 17:41:12'),
(9, '37.621317', '-122.378955', '2014-07-07 10:04:43', '2014-07-09 17:44:54'),
(10, '37.784978', '-122.406871', '2014-07-07 10:04:43', '2014-07-09 17:47:18'),
(11, '37.789613', '-122.413399', '2014-07-07 10:04:43', '2014-07-09 16:58:11'),
(12, '37.806921', '-122.405194', '2014-07-07 10:04:43', '2014-07-09 17:46:52'),
(13, '37.810572', '-122.411517', '2014-07-07 10:04:43', '2014-07-09 16:59:57'),
(14, '37.808547', '-122.414649', '2014-07-07 10:04:43', '2014-07-09 17:43:50'),
(15, '37.790996', '-122.416191', '2014-07-07 10:04:43', '2014-07-09 17:29:50'),
(16, '37.782255', '-122.494308', '2014-07-07 10:04:43', '2014-07-09 17:02:51'),
(17, '37.793627', '-122.483878', '2014-07-07 10:04:43', '2014-07-09 17:04:12'),
(18, '37.832523', '-122.479678', '2014-07-07 10:04:43', '2014-07-09 17:05:48'),
(19, '37.795270', '-122.393155', '2014-07-07 10:04:43', '2014-07-09 17:13:18'),
(20, '37.771513', '-122.468712', '2014-07-07 10:04:43', '2014-07-09 17:18:09'),
(21, '37.770375', '-122.445191', '2014-07-07 10:04:43', '2014-07-09 17:31:50'),
(22, '37.800062', '-122.439521', '2014-07-07 10:04:43', '2014-07-09 17:42:40'),
(23, '37.786859', '-122.401001', '2014-07-07 10:04:43', '2014-07-09 17:21:27'),
(24, '37.758183', '-122.427921', '2014-07-07 10:04:43', '2014-07-09 17:23:00'),
(25, '37.762992', '-122.420593', '2014-07-07 10:04:43', '2014-07-09 17:25:20'),
(26, '37.802317', '-122.405810', '2014-07-07 10:04:43', '2014-07-09 17:26:36'),
(27, '37.794348', '-122.392142', '2014-07-07 10:04:43', '2014-07-09 17:49:21');

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE IF NOT EXISTS `migrations` (
  `migration` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`migration`, `batch`) VALUES
('2014_04_07_140331_create_user', 1),
('2014_04_07_140349_create_trip', 1),
('2014_04_07_140414_create_usertrip', 1),
('2014_04_07_140622_create_area', 1),
('2014_04_07_140627_create_place', 1),
('2014_04_07_140639_create_type', 1),
('2014_04_07_140643_create_link', 1),
('2014_04_07_140652_create_attachment', 1),
('2014_04_07_143905_create_location', 1),
('2014_04_08_165620_add_foreign_keys', 1);

-- --------------------------------------------------------

--
-- Table structure for table `places`
--

CREATE TABLE IF NOT EXISTS `places` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `notes` text COLLATE utf8_unicode_ci NOT NULL,
  `area_id` int(10) unsigned NOT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `places_area_id_foreign` (`area_id`),
  KEY `places_type_id_foreign` (`type_id`),
  KEY `places_location_id_foreign` (`location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=29 ;

--
-- Dumping data for table `places`
--

INSERT INTO `places` (`id`, `name`, `notes`, `area_id`, `type_id`, `location_id`, `created_at`, `updated_at`) VALUES
(1, '21st Amendment Brewery', 'Also does food.', 1, 3, 2, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(2, 'Anchor Brewery', 'Tour on May 8th 13:00.', 1, 3, 3, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(3, 'Providence Park', 'Portland Timbers v LA Galaxy Sun 11th May.', 2, 4, 4, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(4, 'Alcatraz', 'Price $30 (includes Audio Tour and Ferry crossing). Should be booked in advance. Ferry from Pier 33.', 1, 2, 5, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(5, 'Oakland A''s Coliseum', 'Accessible directly by BART which means you don''t really see Oakland. There are cheap seats up in the gods but right behind the plate that offer discounts within the stadium.', 3, 4, 7, '2014-07-07 10:04:43', '2014-07-09 17:37:10'),
(6, 'San Francisco Giants', 'Sadly weren''t playing. Worth a night out especially since 21st Amendment is close by.', 3, 4, 8, '2014-07-07 10:04:43', '2014-07-09 17:41:12'),
(7, 'San Francisco SFO Airport', 'Great views flying in (at least from UK) if you on the left side of the plane. BART is quick and easy from airport to downtown.', 3, 5, 9, '2014-07-07 10:04:43', '2014-07-09 17:44:54'),
(8, 'Powell Street BART', 'Use this station rather than Civic Center as Powell Street area is considered safer. It felt it.', 3, 5, 10, '2014-07-07 10:04:43', '2014-07-09 17:47:18'),
(9, 'Mayflower Hotel', 'Grocery store next to hotel. All uphill from Powell Station.', 3, 6, 11, '2014-07-07 10:04:43', '2014-07-09 16:58:11'),
(10, 'Alcatraz Cruise Ferry', 'The only way to get to Alcatraz. The ferry crossing is fun enough and bumpy at times.', 3, 5, 12, '2014-07-07 10:04:43', '2014-07-09 17:46:52'),
(11, 'Pier 39 Sea Lions', 'Worth a quick stop, otherwise this area is a bit of a tourist trap.', 3, 1, 13, '2014-07-07 10:04:43', '2014-07-09 16:59:57'),
(12, 'Boudin', 'Famous sourdough bakery, incredibly popular. Bay shrimp sandwich was very tasty.', 3, 2, 14, '2014-07-07 10:04:43', '2014-07-09 17:43:50'),
(13, 'Zeki''s Bar', 'Quiet bar, fairly good beer selection, sports on above bar. Not for everyone but a safe bet.', 3, 3, 15, '2014-07-07 10:04:43', '2014-07-09 17:29:50'),
(14, 'Lincoln Park Golf Club', 'The #1 bus stops nearby on Geary. Great peaceful walk up to Legion of Honor vista point then continue walk down to Baker Beach.', 3, 1, 16, '2014-07-07 10:04:43', '2014-07-09 17:02:51'),
(15, 'Baker Beach', 'Great view of Golden Gate Bridge especially by the rocks. Brutal sandy staircase used for uphill training.', 3, 1, 17, '2014-07-07 10:04:43', '2014-07-09 17:04:12'),
(16, 'Golden Gate Bridge Vista', 'A decent vista point looking back across Golden Gate Bridge and the bay area. Much less crowded on this side due to the general fitness of tourists!', 3, 1, 18, '2014-07-07 10:04:43', '2014-07-09 17:05:48'),
(17, 'Ferry Building Market', 'Worth a wander out back for views of Oakland Bridge. A good place to go instead of waiting at the Amtrak station next door.', 3, 1, 19, '2014-07-07 10:04:43', '2014-07-09 17:13:18'),
(18, 'De Young Museum', 'Georgia O''Keefe exhibition at the time. Is pretty expensive otherwise. The African section upstairs was the best of the permanent exhibitions and surprisingly quiet.', 3, 1, 20, '2014-07-07 10:04:43', '2014-07-09 17:18:09'),
(19, 'Magnolia', 'A brewpub for a popular local brewery. Food and beers were good.', 3, 3, 21, '2014-07-07 10:04:43', '2014-07-09 17:31:50'),
(20, 'Run & Chug @ Monaghan''s', 'Friendly bunch of runners who head out every week for a run then beers. On this occasion it was a brutal run around the Presidio area.', 3, 4, 22, '2014-07-07 10:04:43', '2014-07-09 17:42:40'),
(21, 'Cartoon Art Museum', 'A nice little museum made up of only a few rooms. The Teenage Mutant Ninja Turtles exhibition was worth entry alone. Shame I missed the Steve Purcell exhibition. Changes are made fairly regularly.', 3, 1, 23, '2014-07-07 10:04:43', '2014-07-09 17:21:27'),
(22, 'Dalores Park', 'Was undergoing major renovation in May 2014 but regardless you should still walk to the south west corner (the highest point). Sit and stare back across San Francisco. Great spot.', 3, 1, 24, '2014-07-07 10:04:43', '2014-07-09 17:23:00'),
(23, 'Clarion Alley', 'The street art here is pretty immense. There is also Balmy Street off 24th but I preferred the art on Clarion.', 3, 1, 25, '2014-07-07 10:04:43', '2014-07-09 17:25:20'),
(24, 'Coit Tower', 'Offers great views all across the area. Under renovation until June 2014.', 3, 1, 26, '2014-07-07 10:04:43', '2014-07-09 17:26:36'),
(25, 'Amtrak - Ferry Building', 'If you are catching a connection to an Amtrak train then it will be from here. The entrance for check-in is around the back of the building but wait for bus by road. If long wait, the Ferry Building is next door.', 3, 5, 27, '2014-07-07 10:04:43', '2014-07-09 17:49:21'),
(26, '21st Amendment Brewery', 'A bit away from all the action unless heading to the Giants Stadium. All the beers I tried were top notch and the food was decent quality too.', 3, 3, 2, '2014-07-07 10:04:43', '2014-07-09 17:33:25'),
(27, 'Anchor Brewery', 'Free tours available with plenty of tasters at the end. They are looking to relocate next to the Giants stadium but will keep this location open too. All beer they produce is currently from this location regardless of where it is sold.', 3, 3, 3, '2014-07-07 10:04:43', '2014-07-09 17:35:10'),
(28, 'Alcatraz', 'Price $30 (includes Audio Tour and Ferry crossing). Should be booked in advance but not paramount. Ferry from Pier 33. Nice gardens and wildlife on the south west of the island that is missed by most.', 3, 1, 5, '2014-07-07 10:04:43', '2014-07-09 17:27:34');

-- --------------------------------------------------------

--
-- Table structure for table `trips`
--

CREATE TABLE IF NOT EXISTS `trips` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `base_zoom` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `trips`
--

INSERT INTO `trips` (`id`, `name`, `location_id`, `base_zoom`, `created_at`, `updated_at`) VALUES
(1, 'US/Canada 2014', 1, 6, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(2, 'Skiing 2014', 0, 0, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(3, 'San Francisco 2014', 6, 12, '2014-07-07 10:04:43', '2014-07-07 10:04:43');

-- --------------------------------------------------------

--
-- Table structure for table `trip_user`
--

CREATE TABLE IF NOT EXISTS `trip_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `trip_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `trip_user_user_id_foreign` (`user_id`),
  KEY `trip_user_trip_id_foreign` (`trip_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `trip_user`
--

INSERT INTO `trip_user` (`id`, `user_id`, `trip_id`, `created_at`, `updated_at`) VALUES
(1, 1, 1, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(2, 1, 2, '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(3, 2, 3, '2014-07-07 10:04:43', '2014-07-07 10:04:43');

-- --------------------------------------------------------

--
-- Table structure for table `types`
--

CREATE TABLE IF NOT EXISTS `types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `types`
--

INSERT INTO `types` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, 'Attractions', '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(2, 'Food', '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(3, 'Drink', '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(4, 'Events', '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(5, 'Travel', '2014-07-07 10:04:42', '2014-07-07 10:04:42'),
(6, 'Accommodation', '2014-07-07 10:04:42', '2014-07-07 10:04:42');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `login_expire` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `last_access` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `password`, `login_expire`, `access_token`, `last_access`, `created_at`, `updated_at`) VALUES
(1, 'ando', 'me@andrewcobley.co.uk', '$2y$10$UHBinb1VuiMnfT5gjXA/p.UVN9VOmhMZj0QC7184/RBBCK.3gogtW', '2014-07-15 13:25:33', '4e6ad44ecf1e2249e724e2d7e1dcb799', '2014-07-08 13:25:36', '2014-07-07 10:04:42', '2014-07-08 13:25:36'),
(2, 'demo', 'help@andrewcobley.co.uk', '$2y$10$x/6iqAv6yePwiMWilerw9uoHey511KsvJpZO6m/SmB332TVN3fV.G', '2014-07-17 09:21:37', '8713b900a50f7b65a34c84b30411a8f5', '2014-07-10 09:21:53', '2014-07-07 10:04:43', '2014-07-10 09:21:53');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `areas`
--
ALTER TABLE `areas`
  ADD CONSTRAINT `areas_trip_id_foreign` FOREIGN KEY (`trip_id`) REFERENCES `trips` (`id`);

--
-- Constraints for table `attachments`
--
ALTER TABLE `attachments`
  ADD CONSTRAINT `attachments_place_id_foreign` FOREIGN KEY (`place_id`) REFERENCES `places` (`id`);

--
-- Constraints for table `links`
--
ALTER TABLE `links`
  ADD CONSTRAINT `links_place_id_foreign` FOREIGN KEY (`place_id`) REFERENCES `places` (`id`);

--
-- Constraints for table `places`
--
ALTER TABLE `places`
  ADD CONSTRAINT `places_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`),
  ADD CONSTRAINT `places_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`),
  ADD CONSTRAINT `places_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `types` (`id`);

--
-- Constraints for table `trip_user`
--
ALTER TABLE `trip_user`
  ADD CONSTRAINT `trip_user_trip_id_foreign` FOREIGN KEY (`trip_id`) REFERENCES `trips` (`id`),
  ADD CONSTRAINT `trip_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
