<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the Closure to execute when that URI is requested.
|
*/

// Route group for API versioning
/*
Route::group(array('prefix' => 'api/v1', 'before' => 'auth.basic'), function()
{
    Route::resource('trip', 'TripController');
});
*/


// Route group for API versioning
Route::group(array('prefix' => 'api/v1'), function()
{
    Route::post('login', 'UserController@authenticateLogin');

    Route::group(array('before' => 'auth.token'), function()
    {
        Route::get('auth', 'UserController@userActive');
        
        Route::get('trip/user', 'TripController@userTrips');

        Route::get('trip/{trip}/directory', 'TripController@directory');

        Route::get('trip/{trip}/area/{area}', 'AreaController@show');
        Route::post('trip/{trip}/area', 'AreaController@store');
        Route::patch('trip/{trip}/area', 'AreaController@update');
        Route::delete('trip/{trip}/area/{area}', 'AreaController@destroy');
    
        Route::resource('place', 'PlaceController');
        Route::get('place/{place}/all', 'PlaceController@all');
        Route::get('trip/{trip}/place/{place}', 'PlaceController@show');
        Route::post('trip/{trip}/place', 'PlaceController@store');
        Route::patch('trip/{trip}/place', 'PlaceController@update');
        Route::delete('trip/{trip}/place/{place}', 'PlaceController@destroy');
    
        Route::get('trip/{trip}/types', 'TypeController@index');





        Route::group(array('before' => 'auth.trip'), function()
        {
            
        });
    });

    // >>> AUTH GROUP

	// Route::resource('area', 'AreaController', ['only' => ['index','show']]);
    //Route::resource('trip', 'TripController');
    //Route::get('trip/{trip}/directory', 'TripController@directory');

    //Route::resource('area', 'AreaController');


    Route::any('{all}', function($uri)
    {
        return View::make('index.html');
    })->where('all', '.*');
});