<?php

use Illuminate\Auth\UserInterface;
use Illuminate\Auth\Reminders\RemindableInterface;

class User extends Eloquent implements UserInterface, RemindableInterface
{
    protected $table  = "users";
    protected $hidden = ["password"];

    public static $rules = [
        'email' => 'required',
        'password' => 'required'
    ];

    public function trips()
    {
    	return $this->belongsToMany('Trip')->withTimestamps();
    }

    public function isValid($data)
    {
            $validation = Validator::make($data, static::$rules);

            if($validation->passes())
            {
                return true;
            }

            $this->errors = $validation->messages();
            return false;
    }

    public function getAuthIdentifier()
    {
        return $this->getKey();
    }

    public function getAuthPassword()
    {
        return $this->password;
    }

    public function getReminderEmail()
    {
        return $this->email;
    }

}