<?php

class Trip extends Eloquent
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'trips';

    public static $rules = [
        'name' => 'required'
    ];

    public $errors;

    /**
     * The relationship with table [users].
     */
    public function users()
    {
    	return $this->belongsToMany('User')->withTimestamps();
    }

    /**
     * The relationship with table [locations].
     */
    public function location()
    {
        return $this->belongsTo('Location');
    }

    /**
     * The relationship with table [areas].
     */
    public function areas()
    {
        return $this->hasMany('Area');
    }

    public function isValid($data)
    {
    		$validation = Validator::make($data, static::$rules);

    		if($validation->passes())
    		{
    			return true;
    		}

    		$this->errors = $validation->messages();
    		return false;
    }

}