<?php

class Place extends Eloquent
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'places';


    /**
     * The rules used for validation.
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required',
        'area' => 'required',
        'type' => 'required',
        'location' => 'required'
    ];

    public $messages;

    /**
     * The relationship with table [areas].
     */
    public function area()
    {
        return $this->belongsTo('Area');
    }

    /**
     * The relationship with table [types].
     */
    public function type()
    {
        return $this->belongsTo('Type');
    }


    /**
     * The relationship with table [locations].
     */
    public function location()
    {
        return $this->belongsTo('Location');
    }

    /**
     * The relationship with table [links].
     */
    public function links()
    {
        return $this->hasMany('Link');
    }

    /**
     * The relationship with table [attachments].
     */
    public function attachments()
    {
        return $this->hasMany('Attachment');
    }

    /**
     * Validation Testing.
     */
    public function isValid($place)
    {
        $validator = Validator::make($place, static::$rules);

        if( $validator->fails() )
        {
            $this->messages = $validator->messages()->toArray();

            return false;
        }

        return true;

    }

}