<?php

class Location extends Eloquent
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'locations';


    /**
     * The rules used for validation.
     *
     * @var array
     */
    public static $rules = [
        'geolat' => 'required',
        'geolng' => 'required',
    ];

    /**
     * The relationship with table [places].
     */
    public function place()
    {
        return $this->hasOne('Place');
    }

    /**
     * The relationship with table [trips].
     */
    public function trips()
    {
        return $this->hasOne('Trip');
    }


}