<?php

class Area extends Eloquent
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'areas';

    /**
     * The rules used for validation.
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required',
        'trip_id' => 'required'
    ];

    public $messages;

    /**
     * The relationship with table [trips].
     */
    public function trip()
    {
        return $this->belongsTo('Trip');
    }

    /**
     * The relationship with table [places].
     */
    public function places()
    {
    	return $this->hasMany('Place');
    }

    /**
     * Validation Testing.
     */
    public function isValid($area)
    {
        $validator = Validator::make($area, static::$rules);

        if( $validator->fails() )
        {
            $this->messages = $validator->messages()->toArray();
            //$this->messages = 'Error';

            return false;
        }

        return true;

    }

}