<?php

/*
|--------------------------------------------------------------------------
| Application & Route Filters
|--------------------------------------------------------------------------
|
| Below you will find the "before" and "after" events for the application
| which may be used to do any work before or after a request into your
| application. Here you may also register your custom route filters.
|
*/

App::before(function($request)
{
	//
});


App::after(function($request, $response)
{
	//
});

/*
|--------------------------------------------------------------------------
| Authentication Filters
|--------------------------------------------------------------------------
|
| The following filters are used to verify that the user of the current
| session is logged into this application. The "basic" filter easily
| integrates HTTP Basic authentication for quick, simple checking.
|
*/

Route::filter('auth', function()
{
	if (Auth::guest()) return Redirect::guest('login');
});


Route::filter('auth.basic', function()
{
	return Auth::basic('username');
});


Route::filter('auth.token', function()
{
	$header = Input::header();

	if( isset($header['token']) )
	{
		$token = $header['token'][0];
	}
	else
	{
		$data['errors'] = 'Unauthorised Access 1';
		$response = Response::make($data, 401);
		return $response;
	}
	

	// Find User Given Token
	// !!! CHANGE - $token SHOULD SECRETLY INDICATE USER
	$user = User::where('access_token', '=', $token)->first();

	if(!$user)
	{
		$data['errors'] = 'Unauthorised Access 2';
		return $data;
	}

	// Check if Login Required. [>1 Week]
	if( date('Y-m-d H:i:s') > $user['login_expire'] )
	{
		// Login has expired
		$data['errors'] = 'Login has expired [Forced]';
		return $data;
	}

	// Check if User Recently Active [< 1 Day]
	if( date('Y-m-d H:i:s') > date('Y-m-d H:i:s', strtotime($user->last_access) + 86000) )
	{
		// Login has expired
		$data['errors'] = 'Login has expired [No Activity]';
		return $data;
	}

	// Update Active Timestamp for User.
	$user->last_access = date('Y-m-d H:i:s');
	//$this->user->access_token = md5(uniqid(mt_rand(), true));
	$user->save();

});

/*
|--------------------------------------------------------------------------
| Guest Filter
|--------------------------------------------------------------------------
|
| The "guest" filter is the counterpart of the authentication filters as
| it simply checks that the current user is not logged in. A redirect
| response will be issued if they are, which you may freely change.
|
*/

Route::filter('guest', function()
{
	if (Auth::check()) return Redirect::to('/');
});

/*
|--------------------------------------------------------------------------
| CSRF Protection Filter
|--------------------------------------------------------------------------
|
| The CSRF filter is responsible for protecting your application against
| cross-site request forgery attacks. If this special token in a user
| session does not match the one given in this request, we'll bail.
|
*/

Route::filter('csrf', function()
{
	if (Session::token() != Input::get('_token'))
	{
		throw new Illuminate\Session\TokenMismatchException;
	}
});