<?php


class PopulateDemo extends Seeder
{
	public function run()
	{

		// USER - Trip Demo
		$user = new User();
		$user->username = 'demo';
		$user->email = 'help@andrewcobley.co.uk';
		$user->password = Hash::make('tripdemo');
		$user->save();

		// LOC - San Francisco
		$location = new Location();
		$location->geolat = '37.798113';
		$location->geolng = '-122.395494';
		$location->save();

		// TRIP - San Francisco
		$trip = new Trip();
		$trip->name = 'San Francisco 2014';
		$trip->base_zoom = 12;
		$trip->location()->associate($location);
		$trip->save();
		$trip->users()->attach($user->id);

		// AREA - San Francisco
		$area = new Area();
		$area->name = 'San Francisco';
		$area->additional = '04 May - 11 May';
		$area->trip()->associate($trip);
		$area->save();


		// 7 - Oakland A's 
		$location = new Location();
		$location->geolat = '37.752338';
		$location->geolng = '-122.199238';
		$location->save();

		$place = new Place();
		$place->name = "Oakland A's Coliseum";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(4));
		$place->location()->associate($location);
		$place->save();

		// 8 - SF Giants
		$location = new Location();
		$location->geolat = '37.778889';
		$location->geolng = '-122.389729';
		$location->save();

		$place = new Place();
		$place->name = "San Francisco Giants";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(4));
		$place->location()->associate($location);
		$place->save();

		// 9 - SFO
		$location = new Location();
		$location->geolat = '37.621317';
		$location->geolng = '-122.378955';
		$location->save();

		$place = new Place();
		$place->name = "San Francisco SFO Airport";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(5));
		$place->location()->associate($location);
		$place->save();

		// 10 - BART Powell St
		$location = new Location();
		$location->geolat = '37.784978';
		$location->geolng = '-122.406871';
		$location->save();

		$place = new Place();
		$place->name = "Powell Street BART Station";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(5));
		$place->location()->associate($location);
		$place->save();

		// 11 - Mayflower Hotel
		$location = new Location();
		$location->geolat = '37.789613';
		$location->geolng = '-122.413399';
		$location->save();

		$place = new Place();
		$place->name = "Mayflower Hotel";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(6));
		$place->location()->associate($location);
		$place->save();

		// 12 - Pier 33
		$location = new Location();
		$location->geolat = '37.806921';
		$location->geolng = '-122.405194';
		$location->save();

		$place = new Place();
		$place->name = "Alcatraz Cruise Ferry";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(5));
		$place->location()->associate($location);
		$place->save();

		// 13 - Pier 39 - Sea Lions
		$location = new Location();
		$location->geolat = '37.810572';
		$location->geolng = '-122.411517';
		$location->save();

		$place = new Place();
		$place->name = "Pier 39";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 14 - Boudin
		$location = new Location();
		$location->geolat = '37.808547';
		$location->geolng = '-122.414649';
		$location->save();

		$place = new Place();
		$place->name = "Boudin";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(2));
		$place->location()->associate($location);
		$place->save();

		// 15 - Zeki's Bar
		$location = new Location();
		$location->geolat = '37.790996';
		$location->geolng = '-122.416191';
		$location->save();

		$place = new Place();
		$place->name = "Zeki's Bar";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(3));
		$place->location()->associate($location);
		$place->save();

		// 16 - Lincoln Park Golf Club
		$location = new Location();
		$location->geolat = '37.782255';
		$location->geolng = '-122.494308';
		$location->save();

		$place = new Place();
		$place->name = "Lincoln Park Golf Club";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 17 - Baker Beach
		$location = new Location();
		$location->geolat = '37.793627';
		$location->geolng = '-122.483878';
		$location->save();

		$place = new Place();
		$place->name = "Baker Beach";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 18 - Golden Gate Bridge Lookout
		$location = new Location();
		$location->geolat = '37.832523';
		$location->geolng = '-122.479678';
		$location->save();

		$place = new Place();
		$place->name = "Golden Gate Bridge Lookout";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 19 - Ferry Building
		$location = new Location();
		$location->geolat = '37.795270';
		$location->geolng = '-122.393155';
		$location->save();

		$place = new Place();
		$place->name = "Ferry Building Marketplace";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 20 - De Young Museum
		$location = new Location();
		$location->geolat = '37.771513';
		$location->geolng = '-122.468712';
		$location->save();

		$place = new Place();
		$place->name = "De Young Museum";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 21 - Magnolia
		$location = new Location();
		$location->geolat = '37.770375';
		$location->geolng = '-122.445191';
		$location->save();

		$place = new Place();
		$place->name = "Magnolia";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(3));
		$place->location()->associate($location);
		$place->save();

		// 22 - Run & Chug
		$location = new Location();
		$location->geolat = '37.800062';
		$location->geolng = '-122.439521';
		$location->save();

		$place = new Place();
		$place->name = "Run & Chug @ Monaghan's";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(4));
		$place->location()->associate($location);
		$place->save();

		// 23 - Cartoon Art Museum
		$location = new Location();
		$location->geolat = '37.786859';
		$location->geolng = '-122.401001';
		$location->save();

		$place = new Place();
		$place->name = "Cartoon Art Museum";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 24 - Dalores Park
		$location = new Location();
		$location->geolat = '37.758183';
		$location->geolng = '-122.427921';
		$location->save();

		$place = new Place();
		$place->name = "Dalores Park";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 25 - Clarion Alley
		$location = new Location();
		$location->geolat = '37.762992';
		$location->geolng = '-122.420593';
		$location->save();

		$place = new Place();
		$place->name = "Clarion Alley";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 26 - Coit Tower
		$location = new Location();
		$location->geolat = '37.802317';
		$location->geolng = '-122.405810';
		$location->save();

		$place = new Place();
		$place->name = "Coit Tower";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(1));
		$place->location()->associate($location);
		$place->save();

		// 27 - Amtrak
		$location = new Location();
		$location->geolat = '37.794348';
		$location->geolng = '-122.392142';
		$location->save();

		$place = new Place();
		$place->name = "Amtrak Station - Ferry Building";
		$place->notes = 'Saver Tickets...';
		$place->area()->associate($area);
		$place->type()->associate(Type::find(5));
		$place->location()->associate($location);
		$place->save();


		$place = new Place();
		$place->name = '21st Amendment Brewery';
		$place->notes = 'Also does food.';
		$place->area()->associate(Area::find(3));
		$place->type()->associate(Type::find(3));
		$place->location()->associate(Location::find(2));
		$place->save();


		$place = new Place();
		$place->name = 'Anchor Brewery';
		$place->notes = 'Tour on May 8th 13:00.';
		$place->area()->associate(Area::find(3));
		$place->type()->associate(Type::find(3));
		$place->location()->associate(Location::find(3));
		$place->save();


		$place = new Place();
		$place->name = 'Alcatraz';
		$place->notes = 'Price $30 (includes Audio Tour and Ferry crossing). Should be booked in advance. Ferry from Pier 33.';
		$place->area()->associate(Area::find(3));
		$place->type()->associate(Type::find(1));
		$place->location()->associate(Location::find(5));
		$place->save();

	}
}

