<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignKeys extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('trip_user', function(Blueprint $table)
		{
			$table->foreign('user_id')->references('id')->on('users');
			$table->foreign('trip_id')->references('id')->on('trips');
		});

		Schema::table('areas', function(Blueprint $table)
		{
			$table->foreign('trip_id')->references('id')->on('trips');
		});

		Schema::table('places', function(Blueprint $table)
		{
			$table->foreign('area_id')->references('id')->on('areas');
			$table->foreign('type_id')->references('id')->on('types');
			$table->foreign('location_id')->references('id')->on('locations');
		});

		Schema::table('links', function(Blueprint $table)
		{
			$table->foreign('place_id')->references('id')->on('places');
		});

		Schema::table('attachments', function(Blueprint $table)
		{
			$table->foreign('place_id')->references('id')->on('places');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('trip_user', function(Blueprint $table)
		{
			$table->dropForeign('trip_user_trip_id_foreign');
			$table->dropForeign('trip_user_user_id_foreign');
		});

		Schema::table('areas', function(Blueprint $table)
		{
			$table->dropForeign('areas_trip_id_foreign');
		});

		Schema::table('places', function(Blueprint $table)
		{
			$table->dropForeign('places_area_id_foreign');
			$table->dropForeign('places_type_id_foreign');
			$table->dropForeign('places_location_id_foreign');
		});

		Schema::table('links', function(Blueprint $table)
		{
			$table->dropForeign('links_place_id_foreign');
		});

		Schema::table('attachments', function(Blueprint $table)
		{
			$table->dropForeign('attachments_place_id_foreign');
		});
	}

}
