<?php

class UserController extends \ApiController {

	protected $user;

	public function __construct(User $user)
	{
		$this->user = $user;
	}

	/**
	 * Authenticate a Login Attempt.
	 *
	 * @return Response
	 */
	public function authenticateLogin()
	{
		$input = Input::all();

		if ( ! $this->user->isValid($input) )
        {
        	$data['errors'] = 'User credentials not valid';
            return $data;
        }

		$credentials = [
			"email" => Input::get("email"),
			"password" => Input::get("password")
		];

		if (Auth::attempt($credentials))
		{
			// User has been authenticated
			$this->user = Auth::user();
			$this->user->login_expire = date('Y-m-d H:i:s', strtotime('+1 week'));
			$this->user->last_access = date('Y-m-d H:i:s');
			$this->user->access_token = md5(uniqid(mt_rand(), true));
			$this->user->save();

			$data['success'] = $this->user['access_token'];

			if($this->user->username == 'demo')
			{
				$data['demo'] = true;
				$trip = $this->user->trips()->first();;

				$data['demo_trip'] = $trip->id;
			}
			else
			{
				$data['demo'] = false;
			}

			return $data;
		}

        $data['errors'] = 'User credentials not valid 2';
        return $data;

	}

	/**
	 * Authenticate a User Token.
	 *
	 * @return Response
	 */
	public function userActive()
	{
		$data['success'] = 'User already active';
		return $data;
	}


	/**
	 * Display a listing of the resource.
	 *
	 * @return Response
	 */
	public function index()
	{
		//
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		//
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}