<?php

class TripController extends \ApiController
{

	protected $trip;
	protected $tripTransformer;

	public function __construct(Trip $trip, TripTransformer $tripTransformer)
	{
		$this->trip = $trip;
		$this->tripTransformer = $tripTransformer;
	}


	/**
	 * Display a listing of the resource.
	 *
	 * @return Response
	 */
	public function index()
	{
		$trips =  Trip::all();

		return $this->respond([
			'trips' => $this->tripTransformer->transformCollection($trips->toArray())
		]);
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		// Validate Received Data
		if ( ! $this->trip->isValid(Request::all()) )
		{
			return $this->trip->errors;
		}

		return Request::all();

		//$trip = new Trip;
		//$trip->name = Request::get('name');
		//$trip->save();

		// Also needs a new UserTrip
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		return Trip::find($id);
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

	/**
	 * Display a listing of trips including all children.
	 *
	 * @return Response
	 */
	public function directory($id)
	{
		$trip = Trip::find($id);

		if(! $trip)
		{
			return $this->respondNotFound('Trip does not exist');
		}

		return $this->respond([
			'trip' => $this->tripTransformer->transformMenu($trip)
		]);

	}

	/**
	 * Display a listing of trips for user.
	 *
	 * @return Response
	 */
	public function userTrips()
	{
		$header = Input::header();
		$token = $header['token'][0];
		$user = User::where('access_token', '=', $token)->first();

		$trips = $user->trips;

		if(! $trips)
		{
			return $this->respondNotFound('No Trips found for user.');
		}

		return $trips;

	}

}