<?php

class PlaceController extends \ApiController {

	protected $place;
	protected $placeTransformer;

	public function __construct(Place $place, PlaceTransformer $placeTransformer)
	{
		$this->place = $place;
		$this->placeTransformer = $placeTransformer;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @return Response
	 */
	public function index()
	{
		$places =  Place::all();

		return $this->respond([
			'places' => $this->placeTransformer->transformCollection($places->toArray())
		]);
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		$input = Input::all();

        if ( ! $this->place->isValid($input) )
        {
        	$data['errors'] = $this->place->messages;
            return $data;
        }

		$location = new Location();
		$location->geolat = (float)$input['location']['geolat'];
		$location->geolng = (float)$input['location']['geolng'];
		$location->save();

		$place = new Place();
		$place->name = $input['name'];
		if( isset($input['notes']) ) $place->notes = $input['notes'];
		$place->area()->associate(Area::find($input['area']['id']));
		$place->type()->associate(Type::find($input['type']['id']));
		$place->location()->associate(Location::find($location->id));
		$place->save();

		// Loop through links array

		if(isset($input['links']))
		{
			$input_links = $input['links'];
			foreach($input_links as $input_link)
			{
				$link = new Link();
				if( isset($input_link['name']) ) $link->name = $input_link['name'];
				if( isset($input_link['address']) )$link->address = $input_link['address'];
				$link->place()->associate(Place::find($place->id));
				$link->save();
			}
		}

		// Loop through attachments array
		if(isset($input['attachments']))
		{
			$input_attachments = $input['attachments'];
			foreach($input_attachments as $input_attachment)
			{
				$attachment = new Attachment();
				if( isset($input_attachment['name']) ) $attachment->name = $input_attachment['name'];
				if( isset($input_attachment['address']) )$attachment->address = $input_attachment['address'];
				$attachment->place()->associate(Place::find($place->id));
				$attachment->save();
			}
		}


		$data['success'] = [ $place->id, $location->geolat, $location->geolng ];
		return $data;
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($trip_id, $place_id)
	{
		$place = Place::find($place_id);

		if(! $place)
		{
			return $this->respondNotFound('Place does not exist');
		}

		return $this->respond([
			'place' => $this->placeTransformer->transformAll($place)
		]);
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($trip_id)
	{
		$input = Input::all();

        if ( ! $this->place->isValid($input) )
        {
        	$data['errors'] = $this->place->messages;
            return $data;
        }

		$location = Location::find($input['location']['id']);
		$location->geolat = (float)$input['location']['geolat'];
		$location->geolng = (float)$input['location']['geolng'];
		$location->save();

		$place = Place::find($input['id']);
		$place->name = $input['name'];
		if( isset($input['notes']) ) $place->notes = $input['notes'];
		$place->area()->associate(Area::find($input['area']['id']));
		$place->type()->associate(Type::find($input['type']['id']));
		$place->save();

		// Loop through links array

		if(isset($input['links']))
		{
			$input_links = $input['links'];
			foreach($input_links as $input_link)
			{
				$link = Link::find($input_link['id']);
				if(!$link)
				{
					$link = new Link();
					$link->place()->associate(Place::find($place->id));
				}
				if( isset($input_link['name']) ) $link->name = $input_link['name'];
				if( isset($input_link['address']) )$link->address = $input_link['address'];
				$link->save();
			}
		}

		// Loop through attachments array
		if(isset($input['attachments']))
		{
			$input_attachments = $input['attachments'];
			foreach($input_attachments as $input_attachment)
			{
				$attachment = Attachment::find($input_attachment['id']);
				if(!$attachment)
				{
					$attachment = new Attachment();
					$attachment->place()->associate(Place::find($place->id));
				}
				if( isset($input_attachment['name']) ) $attachment->name = $input_attachment['name'];
				if( isset($input_attachment['address']) )$attachment->address = $input_attachment['address'];
				$attachment->save();
			}
		}


		$data['success'] = [ $place->id, $location->geolat, $location->geolng ];
		return $data;
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($trip_id, $place_id)
	{
		$place = Place::find($place_id);

		$links = Link::where('place_id', '=', $place['id'])->get();
		if($links)
		{
			foreach($links as $link)
			{
				$link->delete();
			}
		}

		$attachments = Attachment::where('place_id', '=', $place['id'])->get();
		if($attachments)
		{
			foreach($attachments as $attachment)
			{
				$attachment->delete();
			}
		}

		$location_id = $place['location_id'];

		$place->delete();

		$locations = Location::where('id', '=', $location_id)->get();
		foreach($locations as $location)
		{
			$location->delete();
		}

		$data['success']['place'] = 'Place Deleted';
		return $data;
	}

	/**
	 * Display a full entry for a place.
	 *
	 * @return Response
	 */
	public function all($id)
	{

		$place = Place::find($id);

		if(! $place)
		{
			return $this->respondNotFound('Place does not exist');
		}

		return $this->respond([
			'place' => $this->placeTransformer->transformAll($place)
		]);

	}

}