<?php

class AreaController extends \ApiController
{

	protected $area;
	protected $areaTransformer;

	public function __construct(Area $area, AreaTransformer $areaTransformer)
	{
		$this->area = $area;
		$this->areaTransformer = $areaTransformer;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @return Response
	 */
	public function index()
	{
		$areas =  Area::all();

		return $this->respond([
			'data' => $this->areaTransformer->transformCollection($areas->toArray())
		]);
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		$input = Input::all();

        if ( ! $this->area->isValid($input) )
        {
        	$data['errors'] = $this->area->messages;
            return $data;
        }

		$area = new Area();
		$area->name = $input['name'];
		if( isset($input['additional']) ) $area->additional = $input['additional'];
		$area->trip()->associate(Trip::find($input['trip_id']));
		$area->save();

		$data['success'] = $input;
		return $data;
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($trip_id, $area_id)
	{
		$area = Area::find($area_id);

		if(! $area)
		{

			return $this->respondNotFound('Area does not exist');

		}

		return $this->respond([
			'area' => $this->areaTransformer->transform($area)
		]);
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		$input = Input::all();

        if ( ! $this->area->isValid($input) )
        {
        	$data['errors'] = $this->area->messages;
            return $data;
        }

		$area = Area::find($input['id']);
		$area->name = $input['name'];
		if( isset($input['additional']) ) $area->additional = $input['additional'];
		$area->save();

		$data['success'] = $input;
		return $data;
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($trip_id, $area_id)
	{
		$area = Area::find($area_id);

		// Remove related place records
		$places = Place::where('area_id', '=', $area_id)->get();
		if($places)
		{
			$count = 0;
			foreach($places as $place)
			{
				$links = Link::where('place_id', '=', $place['id'])->get();
				if($links)
				{
					foreach($links as $link)
					{
						$link->delete();
					}
				}

				$attachments = Attachment::where('place_id', '=', $place['id'])->get();
				if($attachments)
				{
					foreach($attachments as $attachment)
					{
						$attachment->delete();
					}
				}
		
				$location_id = $place['location_id'];
		
				$place->delete();
		
				$locations = Location::where('id', '=', $location_id)->get();
				foreach($locations as $location)
				{
					$location->delete();
				}
				$count++;
			}
			$data['success']['places'] = 'Places ('.$count.') Deleted';
		}
		else
		{
			$data['success']['places'] = 'No Places Attached To Area.';
		}

		// Remove area record
		$area->delete();
		$data['success']['area'] = 'Area Deleted';
		return $data;
	}


}