<?php

class ApiController extends \BaseController {

	protected $statusCode = 200;

	/**
	 * Get current status code.
	 *
	 * @return $statusCode
	 */
	public function getStatusCode()
	{
		return $this->statusCode;
	}

	/**
	 * Set current status code.
	 *
	 * @param  $statusCode
	 * @return $this
	 */
	public function setStatusCode($statusCode)
	{
		$this->statusCode = $statusCode;

		return $this;
	}

	/**
	 * Respond > Not Found
	 *
	 * @param  $message (optional)
	 * @return mixed
	 */
	public function respondNotFound($message = "Not found!")
	{
		return $this->setStatusCode(404)->respondWithError($message);
	}

	/**
	 * Respond > With Error
	 *
	 * @param  $message
	 * @return mixed
	 */
	public function respondWithError($message)
	{
		return $this->respond([
			'error' => [
				'message' => $message,
				'status_code' => $this->getStatusCode()
			]
		]);
	}

	/**
	 * Respond > Full Response
	 *
	 * @param  $data, $headers (optional)
	 * @return Response
	 */
	public function respond($data, $headers = [])
	{
		return Response::json($data, $this->getStatusCode(), $headers);
	}

}