<?php

class TripTransformer extends Transformer
{

	protected $areaTransformer;
	protected $locationTransformer;

	public function __construct(AreaTransformer $areaTransformer, LocationTransformer $locationTransformer)
	{
		$this->areaTransformer = $areaTransformer;
		$this->locationTransformer = $locationTransformer;
	}

	/**
	 * Tranform a trip
	 *
	 * @param $trip
	 * @return array
	 */
	public function transform($trip)
	{
		$data = [
			'name' => $trip['name']
		];

		return $data;
	}

	/**
	 * Tranform a trip meny
	 *
	 * @param $trip
	 * @return array
	 */
	public function transformMenu($trip)
	{
		$data = [];

		$areas = Area::where('trip_id', '=', (int)$trip['id'])->get();

		$count = 0;
		foreach($areas as $area)
		{

			$a = [
				'id' => (int)$area['id'],
				'name' => $area['name'],
				'additional' => $area['additional']
			];

			$types = Type::orderBy('name')->get();

			$area_types = [];

			foreach($types as $type)
			{
				$t = [
					'id' => (int)$type['id'],
					'name' => $type['name']
				];

				$places = Place::where('area_id', '=', (int)$area['id'])
							->where('type_id', '=', (int)$type['id'])
							->get();

				$area_type_places = [];

				foreach($places as $place)
				{
					$p = [
						'id' => (int)$place['id'],
						'name' => $place['name']
					];

					$location = $this->locationTransformer->transform(Location::where('id', '=', (int)$place['location_id'])->first());
					$p['location'] = $location;
	
					array_push($area_type_places, $p);
				}

				$t['places'] = $area_type_places;

				array_push($area_types, $t);
			}

			$a['types'] = $area_types;

			array_push($data,$a);


/*

			$places = Place::where('area_id', '=', (int)$area['id'])->get();

			$area_places = [];

			foreach($places as $place)
			{
				$p = [
					'name' => $place['name']
				];

				array_push($area_places, $p);
			}

			$a = [
				'name' => $area['name'],
				'additional' => $area['additional'],
				'places' => $area_places
			];

			array_push($data,$a);*/

			$count++;
		}

		$location = $this->locationTransformer->transform(Location::where('id', '=', (int)$trip['location_id'])->first());

		$data = [
			'id' => (int)$trip['id'],
			'name' => $trip['name'],
			'base_location' => $location,
			'base_zoom' => (int)$trip['base_zoom'],
			'areas' => $data
		];

		return $data;
	}

}