<?php

class PlaceTransformer extends Transformer
{

	protected $areaTransformer;
	protected $typeTransformer;
	protected $attachmentTransformer;
	protected $linkTransformer;
	protected $locationTransformer;

	public function __construct(AreaTransformer $areaTransformer, TypeTransformer $typeTransformer, AttachmentTransformer $attachmentTransformer, LinkTransformer $linkTransformer, LocationTransformer $locationTransformer)
	{
		$this->areaTransformer = $areaTransformer;
		$this->typeTransformer = $typeTransformer;
		$this->attachmentTransformer = $attachmentTransformer;
		$this->linkTransformer = $linkTransformer;
		$this->locationTransformer = $locationTransformer;
	}

	/**
	 * Transform a place
	 *
	 * @param $place
	 * @return array
	 */
	public function transform($place)
	{
		$data = [
			'id' => (int)$place['id'],
			'name' => $place['name'],
			'notes' => $place['notes']
		];

		return $data;
	}

	/**
	 * Transform an full place entry
	 *
	 * @param $place
	 * @return array
	 */
	public function transformAll($place)
	{
		$data = [ ];

		// 1. Place Info
		$info = $this->transform($place->toArray());
		$data['id'] = $info['id'];
		$data['name'] = $info['name'];
		$data['notes'] = $info['notes'];

		// 2. Location Info
		//$data['location'] = $this->locationTransformer->transform(Location::where('place_id', '=', $place['id'])->get());
		//$places = Place::where('area_id', '=', (int)$area['id'])->get();
		$location = $this->locationTransformer->transform(Location::where('id', '=', (int)$place['location_id'])->first());
		$data['location'] = $location;

		// 3. Area Info
		$area = $this->areaTransformer->transform(Area::find($place['area_id']));
		$data['area'] = $area;	

		// 4. Type Info
		$type = $this->typeTransformer->transform(Type::find($place['type_id']));
		$data['type'] = $type;

		// 5. Link Info
		$links = [];
		$linksForPlace = Link::where('place_id', '=', (int)$place['id'])->get();
		foreach ($linksForPlace as $link)
		{
			array_push($links, $this->linkTransformer->transform($link));
		}
		$data['links'] = $links;

		// 6. Attachment Info
		$attachments = [];
		$attachmentsForPlace = Attachment::where('place_id', '=', (int)$place['id'])->get();
		foreach ($attachmentsForPlace as $attachment)
		{
			array_push($attachments, $this->attachmentTransformer->transform($attachment));
		}
		$data['attachments'] = $attachments;

		// > Return Entry
		return $data;
	}

}